/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import techguns.client.ClientProxy;

public class MathUtil {
    public static final double D2R = Math.PI / 180;
    public static final double R2D = 57.29577951308232;

    public static float sin360(float arg) {
        return MathHelper.func_76126_a((float)(arg / 180.0f * (float)Math.PI));
    }

    public static float cos360(float arg) {
        return MathHelper.func_76134_b((float)(arg / 180.0f * (float)Math.PI));
    }

    public static Vec2f polarOffsetXZ(float x, float z, float radius, float angle) {
        return new Vec2f(x += radius * MathHelper.func_76134_b((float)angle), z += radius * MathHelper.func_76126_a((float)angle));
    }

    public static float clamp(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static double clamp(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int randomInt(Random rand, int min, int max) {
        if (max >= min) {
            return min + rand.nextInt(max - min + 1);
        }
        return max + rand.nextInt(min - max + 1);
    }

    public static float randomFloat(Random rand, float min, float max) {
        return min + rand.nextFloat() * (max - min);
    }

    public static Vec3d getInterpolatedEntityPos(Entity entityIn) {
        double partialTicks = ClientProxy.get().PARTIAL_TICK_TIME;
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * partialTicks;
        return new Vec3d(d0, d1, d2);
    }

    public static Vec3d rotateVec3dAroundZ(Vec3d vec, float angle) {
        float f1 = MathHelper.func_76134_b((float)angle);
        float f2 = MathHelper.func_76126_a((float)angle);
        double d0 = vec.field_72450_a * (double)f1 + vec.field_72448_b * (double)f2;
        double d1 = vec.field_72448_b * (double)f1 - vec.field_72450_a * (double)f2;
        double d2 = vec.field_72449_c;
        return new Vec3d(d0, d1, d2);
    }

    public static boolean allInRange(int lowerBound, int upperBound, Integer ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= lowerBound && values[i] <= upperBound) continue;
            return false;
        }
        return true;
    }

    public static int min(Integer ... values) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static int max(Integer ... values) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static int getAverageHeight(Integer ... values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i].intValue();
        }
        return (int)Math.round((double)sum / (double)values.length);
    }

    public static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public static Vec2 polarOffsetXZ(double x, double z, double radius, double angle) {
        return new Vec2(x += radius * Math.cos(angle), z += radius * Math.sin(angle));
    }

    public static Vec3d rotateVector(Vec3d vec, Vec3d axis, double theta) {
        double u = axis.field_72450_a;
        double v = axis.field_72448_b;
        double w = axis.field_72449_c;
        double xPrime = u * (u * vec.field_72450_a + v * vec.field_72448_b + w * vec.field_72449_c) * (1.0 - Math.cos(theta)) + vec.field_72450_a * Math.cos(theta) + (-w * vec.field_72448_b + v * vec.field_72449_c) * Math.sin(theta);
        double yPrime = v * (u * vec.field_72450_a + v * vec.field_72448_b + w * vec.field_72449_c) * (1.0 - Math.cos(theta)) + vec.field_72448_b * Math.cos(theta) + (w * vec.field_72450_a - u * vec.field_72449_c) * Math.sin(theta);
        double zPrime = w * (u * vec.field_72450_a + v * vec.field_72448_b + w * vec.field_72449_c) * (1.0 - Math.cos(theta)) + vec.field_72449_c * Math.cos(theta) + (-v * vec.field_72450_a + u * vec.field_72448_b) * Math.sin(theta);
        return new Vec3d(xPrime, yPrime, zPrime);
    }

    public static boolean inRange(int val, int min, int max) {
        return val >= min && val <= max;
    }

    public static int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static class Vec2 {
        public double x;
        public double y;

        public Vec2(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double lenSquared() {
            return this.x * this.x + this.y * this.y;
        }

        public double len() {
            return Math.sqrt(this.lenSquared());
        }

        public void normalize() {
            double len = this.len();
            if (len > 0.0) {
                double f = 1.0 / len;
                this.x *= f;
                this.y *= f;
            }
        }

        public Vec2 getNormalized() {
            double len = this.len();
            if (len > 0.0) {
                double f = 1.0 / len;
                return new Vec2(this.x * f, this.y * f);
            }
            return new Vec2(0.0, 0.0);
        }

        public static Vec2 substract(Vec2 A, Vec2 B) {
            return new Vec2(B.x - A.x, B.y - A.y);
        }

        public static Vec2 add(Vec2 A, Vec2 B) {
            return new Vec2(B.x + A.x, B.y + A.y);
        }

        public Vec2 getVecTo(Vec2 endpoint) {
            return Vec2.substract(endpoint, this);
        }

        public Vec2 getVecFrom(Vec2 startpoint) {
            return Vec2.substract(this, startpoint);
        }

        public double dot(Vec2 other) {
            return this.x * other.x + this.y * other.y;
        }

        public Vec2 getRotated(float degree) {
            double ynew = this.y * (double)MathUtil.cos360(degree) - this.x * (double)MathUtil.sin360(degree);
            double xnew = this.y * (double)MathUtil.sin360(degree) + this.x * (double)MathUtil.cos360(degree);
            return new Vec2(xnew, ynew);
        }
    }
}

