/*
 * Decompiled with CFR 0.152.
 */
package techguns.tools;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Level;
import net.minecraft.util.ResourceLocation;
import techguns.blocks.GenericBlockMetaEnum;
import techguns.util.TGLogger;

public class BlockJsonCreator {
    private static final String prefix = "../src/main/resources/assets/techguns/";
    private static final String blockstates = "blockstates/";
    private static final String blocks = "models/block/";

    public static void writeBlockModelFile(String name) {
        File f = new File("../src/main/resources/assets/techguns/models/block/" + name + ".json");
        if (!f.exists()) {
            TGLogger.logger_client.log(Level.INFO, "Creating Block Model JSON:" + f.getAbsolutePath());
            try {
                FileWriter writer = new FileWriter(f);
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                JsonObject parent = new JsonObject();
                parent.addProperty("parent", "block/cube_all");
                JsonObject model = new JsonObject();
                model.addProperty("all", "techguns:blocks/" + name);
                parent.add("textures", (JsonElement)model);
                writer.write(gson.toJson((JsonElement)parent));
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeBlockstateJsonFileForBlock(GenericBlockMetaEnum block) {
        String blockname = block.getRegistryName().func_110623_a();
        File f = new File("../src/main/resources/assets/techguns/blockstates/" + blockname + ".json");
        if (!f.exists()) {
            TGLogger.logger_client.log(Level.INFO, "Creating Blockstate JSON:" + f.getAbsolutePath());
            try {
                FileWriter writer = new FileWriter(f);
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                HashMap<String, ImmutableMap> entry = new HashMap<String, ImmutableMap>();
                for (Object t : block.getClazz().getEnumConstants()) {
                    String name = t.toString().toLowerCase();
                    String key = "type=" + name;
                    HashMap<String, String> model = new HashMap<String, String>();
                    model.put("model", new ResourceLocation("techguns", name).toString());
                    entry.put(key, ImmutableMap.copyOf(model));
                    BlockJsonCreator.writeBlockModelFile(name);
                }
                ImmutableMap map = ImmutableMap.copyOf(entry);
                writer.write(gson.toJson((Object)ImmutableMap.of((Object)"variants", (Object)map)));
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

