/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import techguns.TGArmors;
import techguns.items.armors.GenericArmor;
import techguns.items.guns.GenericGun;
import techguns.tileentities.GrinderTileEnt;
import techguns.tileentities.operation.IMachineRecipe;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineOperationChance;
import techguns.util.ItemStackOreDict;

public class GrinderRecipes {
    public static ArrayList<GrinderRecipe> recipes = new ArrayList();

    public static void addRecipe(ItemStackOreDict input, ItemStack ... outputs) {
        recipes.add(new GrinderRecipe(input, outputs));
    }

    public static void addRecipe(ItemStack input, ItemStack ... outputs) {
        recipes.add(new GrinderRecipe(new ItemStackOreDict(input, input.func_190916_E()), outputs));
    }

    public static void removeRecipeFor(ItemStack input) {
        Iterator<GrinderRecipe> it = recipes.iterator();
        while (it.hasNext()) {
            GrinderRecipe r = it.next();
            if (!r.input.matches(input)) continue;
            it.remove();
        }
    }

    public static void addRecipe(GenericGun gun, ItemStack[] ... outputs) {
        ArrayList al = new ArrayList();
        Arrays.stream(outputs).forEach(o -> Arrays.stream(o).forEach(p -> al.add(p)));
        ItemStack input = new ItemStack((Item)gun, 1);
        recipes.add(new GrinderRecipe(new ItemStackOreDict(input, input.func_190916_E()), al.toArray(new ItemStack[al.size()])));
    }

    public static void addRecipe(ItemStack input, ItemStack[] ... outputs) {
        ArrayList al = new ArrayList();
        Arrays.stream(outputs).forEach(o -> Arrays.stream(o).forEach(p -> al.add(p)));
        recipes.add(new GrinderRecipe(new ItemStackOreDict(input, input.func_190916_E()), al.toArray(new ItemStack[al.size()])));
    }

    public static void addRecipeChance(ItemStack input, ItemStack[] outputs, double[] chances) {
        recipes.add(new GrinderRecipeChance(new ItemStackOreDict(input, input.func_190916_E()), outputs, chances));
    }

    public static void addGenericArmorRecipes() {
        TGArmors.armors.forEach(a -> recipes.add(new GrinderRecipeGenericArmor((GenericArmor)a)));
    }

    public static MachineOperation getOperationForInput(ItemStack input, GrinderTileEnt tile) {
        for (GrinderRecipe r : recipes) {
            if (!r.matchesInput(new ItemStackOreDict(input, 1))) continue;
            return r.getOperation(input, tile);
        }
        return null;
    }

    public static boolean hasRecipeForInput(ItemStack input) {
        for (GrinderRecipe r : recipes) {
            if (!r.matchesInput(new ItemStackOreDict(input, 1))) continue;
            return true;
        }
        return false;
    }

    public static class GrinderRecipeGenericArmor
    extends GrinderRecipe {
        protected GenericArmor armor;

        public GrinderRecipeGenericArmor(GenericArmor armor) {
            super(new ItemStackOreDict(new ItemStack((Item)armor), 1), ItemStack.field_190927_a);
            this.armor = armor;
        }

        @Override
        public MachineOperation getOperation(ItemStack input, GrinderTileEnt tile) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(1);
            inputs.add(input);
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            ItemStack inverted = input.func_77946_l();
            inverted.func_77964_b(input.func_77958_k() - input.func_77952_i());
            this.armor.getRepairMats(inverted).forEach(i -> outputs.add(i.func_77946_l()));
            MachineOperation op = new MachineOperation(inputs, outputs, null, null, 1);
            return op;
        }

        @Override
        public boolean matchesInput(ItemStackOreDict input) {
            return input.item != null && !input.isEmpty() && this.armor == input.item.func_77973_b();
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
            NonNullList list2 = NonNullList.func_191197_a((int)1, (Object)new ItemStack((Item)this.armor));
            list.add((List<ItemStack>)list2);
            return list;
        }

        @Override
        public List<List<ItemStack>> getItemOutputs() {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
            this.armor.getRepairMats(new ItemStack((Item)this.armor, 1, this.armor.func_77612_l())).forEach(i -> list.add((List<ItemStack>)NonNullList.func_191197_a((int)1, (Object)i)));
            return list;
        }
    }

    public static class GrinderRecipeChance
    extends GrinderRecipe {
        protected double[] chances;

        public GrinderRecipeChance(ItemStackOreDict input, ItemStack[] outputs, double[] chances) {
            super(input, outputs);
            this.chances = chances;
            if (this.outputs.length != this.chances.length) {
                throw new IllegalArgumentException("Output and Chances array must be same size!");
            }
        }

        public double[] getChances() {
            return this.chances;
        }

        @Override
        public MachineOperationChance getOperation(ItemStack input, GrinderTileEnt tile) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(1);
            ItemStack it = input.func_77946_l();
            it.func_190920_e(1);
            inputs.add(it);
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(this.outputs.length);
            Arrays.stream(this.outputs).forEach(i -> outputs.add((ItemStack)i));
            return new MachineOperationChance(inputs, outputs, null, null, 1, this.chances);
        }
    }

    public static class GrinderRecipe
    implements IMachineRecipe {
        protected ItemStackOreDict input;
        protected ItemStack[] outputs;

        public GrinderRecipe(ItemStackOreDict input, ItemStack ... outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public boolean matchesInput(ItemStackOreDict input) {
            return this.input.matches(input);
        }

        public MachineOperation getOperation(ItemStack input, GrinderTileEnt tile) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(1);
            ItemStack it = input.func_77946_l();
            it.func_190920_e(1);
            inputs.add(it);
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(this.outputs.length);
            Arrays.stream(this.outputs).forEach(i -> outputs.add((ItemStack)i));
            MachineOperation op = new MachineOperation(inputs, outputs, null, null, 1);
            return op;
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            List<List<ItemStack>> list = IMachineRecipe.super.getItemInputs();
            list.add(this.input.getItemStacks());
            return list;
        }

        @Override
        public List<List<ItemStack>> getItemOutputs() {
            List<List<ItemStack>> list = IMachineRecipe.super.getItemOutputs();
            Arrays.stream(this.outputs).forEach(s -> {
                ArrayList<ItemStack> list2 = new ArrayList<ItemStack>();
                list2.add((ItemStack)s);
                list.add(list2);
            });
            return list;
        }
    }
}

