/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import techguns.tileentities.BasicInventoryTileEnt;

public class FluidTankPlus
extends FluidTank {
    BasicInventoryTileEnt tile;

    public FluidTankPlus(BasicInventoryTileEnt tile, int capacity) {
        super(capacity);
        this.tile = tile;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        this.tile.setContentsChanged(true);
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.amount, resource.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.amount));
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, this.fluid.amount));
            }
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.amount;
        if (resource.amount < filled) {
            this.fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        if (this.tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, filled));
        }
        return filled;
    }
}

