/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import techguns.tileentities.ChemLabTileEnt;
import techguns.tileentities.operation.IMachineRecipe;
import techguns.tileentities.operation.MachineOperation;
import techguns.util.ItemStackOreDict;
import techguns.util.ItemUtil;

public class ChemLabRecipes {
    private static ArrayList<ChemLabRecipe> recipes = new ArrayList();
    private static ArrayList<ItemStack> bottleItems = new ArrayList();

    public static MachineOperation getOutputFor(ChemLabTileEnt tile) {
        ItemStack slot1 = tile.input1.get();
        ItemStack slot2 = tile.input2.get();
        ItemStack slot3 = tile.input_bottle.get();
        FluidStack fluidIn = tile.getCurrentInputFluid();
        for (int i = 0; i < recipes.size(); ++i) {
            ChemLabRecipe recipe = recipes.get(i);
            ChemLabRecipe.ChemRecipeType t = recipe.isValidInput(slot1, slot2, slot3, fluidIn);
            if (t == ChemLabRecipe.ChemRecipeType.INVALID) continue;
            return recipe.getOperationFor(tile, t);
        }
        return null;
    }

    public static ArrayList<ChemLabRecipe> getRecipes() {
        return recipes;
    }

    public static int getTotalPower(int recipeIndex) {
        return ChemLabRecipes.recipes.get((int)recipeIndex).powerPerTick * 100;
    }

    public static ChemLabRecipe getRecipe(int index) {
        return recipes.get(index);
    }

    public static ArrayList<ChemLabRecipe> getRecipesUsing(ItemStack input) {
        ArrayList<ChemLabRecipe> ret = new ArrayList<ChemLabRecipe>();
        for (ChemLabRecipe r : recipes) {
            if (!r.isItemPartOfRecipe(input)) continue;
            ret.add(r);
        }
        return ret;
    }

    public static ChemLabRecipe getRecipesFor(ItemStack output) {
        for (ChemLabRecipe r : recipes) {
            if (!ItemUtil.isItemEqual(r.output, output)) continue;
            return r;
        }
        return null;
    }

    protected static void addToFlaskSlot(ItemStack item) {
        if (!item.func_190926_b()) {
            for (int i = 0; i < bottleItems.size(); ++i) {
                if (!ItemStack.func_179545_c((ItemStack)item, (ItemStack)bottleItems.get(i))) continue;
                return;
            }
            ItemStack s = item.func_77946_l();
            s.func_190920_e(1);
            bottleItems.add(s);
        }
    }

    public static boolean allowInFlaskSlot(ItemStack item) {
        if (!item.func_190926_b()) {
            for (int i = 0; i < bottleItems.size(); ++i) {
                if (!ItemStack.func_179545_c((ItemStack)item, (ItemStack)bottleItems.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeUsing(ItemStack item) {
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).isItemPartOfRecipe(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean allowAsInput2(ItemStack slot1, ItemStack item) {
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).isValidInputSlot1_2(slot1, item)) continue;
            return true;
        }
        return false;
    }

    public static void addRecipe(ItemStack input1, int amount1, ItemStack input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(String input1, int amount1, String input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(String input1, int amount1, ItemStack input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(ItemStack input1, int amount1, String input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(ItemStackOreDict input1, int amount1, ItemStackOreDict input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(input1, amount1, input2, amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static class ChemLabRecipe
    implements IMachineRecipe {
        public ItemStackOreDict slot1;
        public ItemStackOreDict slot2;
        public ItemStack slot3;
        public FluidStack fluidIn;
        public FluidStack fluidOutput;
        public boolean allowSwap;
        public ItemStack output;
        public int[] amounts = new int[4];
        public int powerPerTick = 5;

        public boolean isItemPartOfRecipe(ItemStack item) {
            return !this.slot1.isEmpty() && this.slot1.isEqualWithOreDict(item) || !this.slot2.isEmpty() && this.slot2.isEqualWithOreDict(item) || !this.slot3.func_190926_b() && ItemUtil.isItemEqual(this.slot3, item);
        }

        public ChemLabRecipe(ItemStackOreDict slot1, int amount1, ItemStackOreDict slot2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, boolean allowSwap, ItemStack output, FluidStack fluidOutput, int powerPerTick) {
            this.slot1 = slot1;
            this.slot2 = slot2;
            this.slot3 = bottle;
            if (this.slot3 == null) {
                this.slot3 = ItemStack.field_190927_a;
            }
            this.fluidIn = fluidIn;
            this.fluidOutput = fluidOutput;
            this.allowSwap = allowSwap;
            this.output = output;
            if (this.output == null) {
                this.output = ItemStack.field_190927_a;
            }
            this.amounts[0] = amount1;
            this.amounts[1] = amount2;
            this.amounts[2] = amount3;
            this.amounts[3] = fluidIn != null ? fluidIn.amount : 0;
            this.powerPerTick = powerPerTick;
            ChemLabRecipes.addToFlaskSlot(this.slot3);
        }

        public ChemRecipeType isValidInput(ItemStack slot1, ItemStack slot2, ItemStack slot3, FluidStack fluidIn) {
            if (this.slot1.isEqualWithOreDict(slot1) && this.slot2.isEqualWithOreDict(slot2) && (!this.slot3.func_190926_b() && OreDictionary.itemMatches((ItemStack)this.slot3, (ItemStack)slot3, (boolean)true) || this.slot3.func_190926_b() && slot3.func_190926_b()) && this.checkLiquid(fluidIn) && this.checkAmounts(slot1, slot2, slot3, false)) {
                return ChemRecipeType.VALID;
            }
            if (this.allowSwap && this.slot1.isEqualWithOreDict(slot2) && this.slot2.isEqualWithOreDict(slot1) && (!this.slot3.func_190926_b() && OreDictionary.itemMatches((ItemStack)this.slot3, (ItemStack)slot3, (boolean)true) || this.slot3.func_190926_b() && slot3.func_190926_b()) && this.checkLiquid(fluidIn) && this.checkAmounts(slot1, slot2, slot3, true)) {
                return ChemRecipeType.VALID_SWAPPED;
            }
            return ChemRecipeType.INVALID;
        }

        public boolean isValidInputSlot1_2(ItemStack slot1, ItemStack slot2) {
            if (this.slot1.isEqualWithOreDict(slot1) && this.slot2.isEqualWithOreDict(slot2)) {
                return true;
            }
            return this.allowSwap && this.slot1.isEqualWithOreDict(slot2) && this.slot2.isEqualWithOreDict(slot1);
        }

        private boolean isEnoughOrNull(ItemStack item, int amount) {
            if (item.func_190926_b()) {
                return amount == 0;
            }
            return item.func_190916_E() >= amount;
        }

        private boolean checkAmounts(ItemStack slot1, ItemStack slot2, ItemStack slot3, boolean swapped12) {
            ItemStack i1 = slot1;
            ItemStack i2 = slot2;
            if (swapped12) {
                i2 = slot1;
                i1 = slot2;
            }
            return this.isEnoughOrNull(i1, this.amounts[0]) && this.isEnoughOrNull(i2, this.amounts[1]) && this.isEnoughOrNull(slot3, this.amounts[2]);
        }

        private boolean checkLiquid(FluidStack fluid) {
            if (this.fluidIn == null) {
                return true;
            }
            if (fluid == null) {
                return false;
            }
            if (this.fluidIn.getFluid() == fluid.getFluid()) {
                return this.fluidIn.amount <= fluid.amount;
            }
            return false;
        }

        public MachineOperation getOperationFor(ChemLabTileEnt tile, ChemRecipeType t) {
            ItemStack input2;
            ItemStack input1;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(3);
            if (t == ChemRecipeType.VALID_SWAPPED) {
                input1 = tile.input2.get().func_77946_l();
                input1.func_190920_e(this.amounts[1]);
                input2 = tile.input1.get().func_77946_l();
                input2.func_190920_e(this.amounts[0]);
            } else {
                input1 = tile.input1.get().func_77946_l();
                input1.func_190920_e(this.amounts[0]);
                input2 = tile.input2.get().func_77946_l();
                input2.func_190920_e(this.amounts[1]);
            }
            ItemStack bottle = tile.input_bottle.get().func_77946_l();
            bottle.func_190920_e(this.amounts[2]);
            inputs.add(input1);
            inputs.add(input2);
            inputs.add(bottle);
            ArrayList<FluidStack> fluidsIn = new ArrayList<FluidStack>(1);
            if (this.fluidIn != null) {
                FluidStack fluidin = this.fluidIn.copy();
                fluidin.amount = this.amounts[3];
                fluidsIn.add(fluidin);
            }
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(1);
            ItemStack output = this.output.func_77946_l();
            outputs.add(output);
            ArrayList<FluidStack> fluidsOut = new ArrayList<FluidStack>(1);
            if (this.fluidOutput != null) {
                FluidStack fluidout = this.fluidOutput.copy();
                fluidsOut.add(fluidout);
            }
            MachineOperation op = new MachineOperation(inputs, outputs, fluidsIn, fluidsOut, 1);
            op.setPowerPerTick(this.powerPerTick);
            return op;
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            ArrayList<List<ItemStack>> ret = new ArrayList<List<ItemStack>>();
            ret.add(this.slot1.getItemStacks(this.amounts[0]));
            ret.add(this.slot2.getItemStacks(this.amounts[1]));
            ArrayList<ItemStack> bottle = new ArrayList<ItemStack>();
            ItemStack b = this.slot3.func_77946_l();
            b.func_190920_e(this.amounts[2]);
            bottle.add(b);
            ret.add(bottle);
            return ret;
        }

        @Override
        public List<List<ItemStack>> getItemOutputs() {
            ArrayList<List<ItemStack>> ret = new ArrayList<List<ItemStack>>();
            ArrayList<ItemStack> out = new ArrayList<ItemStack>();
            out.add(this.output);
            ret.add(out);
            return ret;
        }

        @Override
        public List<List<FluidStack>> getFluidInputs() {
            ArrayList<List<FluidStack>> ret = new ArrayList<List<FluidStack>>();
            ArrayList<FluidStack> f = new ArrayList<FluidStack>();
            f.add(this.fluidIn);
            ret.add(f);
            return ret;
        }

        @Override
        public List<List<FluidStack>> getFluidOutputs() {
            ArrayList<List<FluidStack>> ret = new ArrayList<List<FluidStack>>();
            ArrayList<FluidStack> f = new ArrayList<FluidStack>();
            f.add(this.fluidOutput);
            ret.add(f);
            return ret;
        }

        public static enum ChemRecipeType {
            INVALID,
            VALID,
            VALID_SWAPPED;

        }
    }
}

