/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import techguns.items.armors.ICamoChangeable;
import techguns.tileentities.operation.IMachineRecipe;

public class CamoBenchRecipes {
    protected static HashMap<Block, CamoBenchRecipe> recipes = new HashMap();

    public static void addRecipe(CamoBenchRecipe r) {
        recipes.put(r.blockType, r);
    }

    public static CamoBenchRecipe getRecipeFor(Block b) {
        return recipes.get(b);
    }

    public static ArrayList<CamoBenchRecipe> getRecipes() {
        Iterator<Block> it = recipes.keySet().iterator();
        ArrayList<CamoBenchRecipe> recipe_list = new ArrayList<CamoBenchRecipe>();
        while (it.hasNext()) {
            CamoBenchRecipe rec = recipes.get(it.next());
            recipe_list.add(rec);
            if (!(rec instanceof TGLampCamoBenchRecipe)) continue;
            recipe_list.add(new TGLampCamoBenchRecipe(rec.blockType, 1));
        }
        return recipe_list;
    }

    public static class TGLampCamoBenchRecipe
    extends CamoBenchRecipe {
        protected int num;

        public TGLampCamoBenchRecipe(Block blockType, int num) {
            super(blockType);
            this.num = num;
            this.customMeta = true;
            this.camoblock = (ICamoChangeable)blockType;
        }

        @Override
        protected int getNextMeta(int m) {
            if (m == 0) {
                return 6;
            }
            if (m == 6) {
                return 0;
            }
            if (m == 12) {
                return 13;
            }
            if (m == 13) {
                return 12;
            }
            return 0;
        }

        @Override
        protected int getPrevMeta(int m) {
            return this.getNextMeta(m);
        }

        @Override
        public int getCamoCount() {
            return 2;
        }

        public List<List<ItemStack>> getItemInputs(int num) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (num == 0) {
                stacks.add(new ItemStack(this.blockType, 1, 0));
                stacks.add(new ItemStack(this.blockType, 1, 6));
            } else {
                stacks.add(new ItemStack(this.blockType, 1, 12));
                stacks.add(new ItemStack(this.blockType, 1, 13));
            }
            list.add(stacks);
            return list;
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            return this.getItemInputs(this.num);
        }
    }

    public static class CamoBenchRecipe
    implements IMachineRecipe {
        protected Block blockType;
        protected int firstMeta;
        protected int lastMeta;
        protected ICamoChangeable camoblock;
        protected boolean customMeta = false;

        public CamoBenchRecipe(Block blockType) {
            this.blockType = blockType;
            this.firstMeta = 0;
            this.lastMeta = 15;
        }

        public CamoBenchRecipe(Block blockType, ICamoChangeable camoblock) {
            this.blockType = blockType;
            this.firstMeta = 0;
            this.lastMeta = camoblock.getCamoCount();
            this.customMeta = true;
            this.camoblock = camoblock;
        }

        protected int getNextMeta(int m) {
            if (++m > this.lastMeta) {
                m = this.firstMeta;
            }
            return m;
        }

        protected int getPrevMeta(int m) {
            if (--m < this.firstMeta) {
                m = this.lastMeta;
            }
            return m;
        }

        public int getCamoCount() {
            return this.lastMeta - this.firstMeta + 1;
        }

        public void switchCamo(ItemStack item, boolean back) {
            if (!this.customMeta) {
                int meta = item.func_77960_j();
                int newMeta = back ? this.getPrevMeta(meta) : this.getNextMeta(meta);
                item.func_77964_b(newMeta);
            } else if (this.camoblock != null) {
                this.camoblock.switchCamo(item, back);
            }
        }

        public ICamoChangeable getCamoblock() {
            return this.camoblock;
        }

        public boolean hasCustomMeta() {
            return this.customMeta;
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (!this.customMeta) {
                for (int i = this.firstMeta; i <= this.lastMeta; ++i) {
                    stacks.add(new ItemStack(this.blockType, 1, i));
                }
            } else {
                ItemStack stack = new ItemStack(this.blockType, 1, this.camoblock.getFirstItemCamoDamageValue());
                for (int i = 0; i <= this.camoblock.getCamoCount(); ++i) {
                    stacks.add(stack);
                    stack = stack.func_77946_l();
                    this.camoblock.switchCamo(stack);
                }
            }
            list.add(stacks);
            return list;
        }

        @Override
        public List<List<ItemStack>> getItemOutputs() {
            return this.getItemInputs();
        }
    }
}

