/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGItems;
import techguns.tileentities.operation.IMachineRecipe;

public class AmmoPressBuildPlans {
    public static final int AMMOUNT_PISTOL = 12;
    public static final int AMMOUNT_SHOTGUN = 16;
    public static final int AMMOUNT_RIFLE = 8;
    public static final int AMMOUNT_SNIPER = 4;
    public static ArrayList<ItemStack> metal1 = new ArrayList();
    public static ArrayList<ItemStack> metal2 = new ArrayList();
    public static ArrayList<ItemStack> powder = new ArrayList();

    public static void init(ArrayList<String> metal1_names, ArrayList<String> metal2_names, ArrayList<String> powder_names) {
        int j;
        NonNullList ores;
        String name;
        int i;
        if (metal1_names != null) {
            for (i = 0; i < metal1_names.size(); ++i) {
                name = metal1_names.get(i);
                ores = OreDictionary.getOres((String)name);
                if (ores.size() <= 0) continue;
                for (j = 0; j < ores.size(); ++j) {
                    metal1.add((ItemStack)ores.get(j));
                }
            }
        }
        if (metal2_names != null) {
            for (i = 0; i < metal2_names.size(); ++i) {
                name = metal2_names.get(i);
                ores = OreDictionary.getOres((String)name);
                if (ores.size() <= 0) continue;
                for (j = 0; j < ores.size(); ++j) {
                    ItemStack stack = ((ItemStack)ores.get(j)).func_77946_l();
                    stack.func_190920_e(2);
                    metal2.add(stack);
                }
            }
        }
        if (powder_names != null) {
            for (i = 0; i < powder_names.size(); ++i) {
                name = powder_names.get(i);
                ores = OreDictionary.getOres((String)name);
                if (ores.size() <= 0) continue;
                for (j = 0; j < ores.size(); ++j) {
                    powder.add((ItemStack)ores.get(j));
                }
            }
        }
    }

    public static int getAmountForRecipe(int itemdmg) {
        if (itemdmg == TGItems.PISTOL_ROUNDS.func_77952_i()) {
            return 12;
        }
        if (itemdmg == TGItems.SHOTGUN_ROUNDS.func_77952_i()) {
            return 16;
        }
        if (itemdmg == TGItems.RIFLE_ROUNDS.func_77952_i()) {
            return 8;
        }
        if (itemdmg == TGItems.SNIPER_ROUNDS.func_77952_i()) {
            return 4;
        }
        return 1;
    }

    public static ItemStack[] getPossibleResults() {
        return new ItemStack[]{TGItems.newStack(TGItems.PISTOL_ROUNDS, 12), TGItems.newStack(TGItems.SHOTGUN_ROUNDS, 16), TGItems.newStack(TGItems.RIFLE_ROUNDS, 8), TGItems.newStack(TGItems.SNIPER_ROUNDS, 4)};
    }

    public static boolean isInList(ItemStack it, ArrayList<ItemStack> list) {
        boolean valid = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!OreDictionary.itemMatches((ItemStack)list.get(i), (ItemStack)it, (boolean)false)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    public static boolean isValidFor(ItemStack input, int slot) {
        switch (slot) {
            case 0: {
                return AmmoPressBuildPlans.isInList(input, metal1);
            }
            case 1: {
                return AmmoPressBuildPlans.isInList(input, metal2);
            }
            case 2: {
                return AmmoPressBuildPlans.isInList(input, powder);
            }
        }
        return false;
    }

    public static int getTotalPower(int recipeIndex) {
        return 500;
    }

    public static ItemStack getOutputFor(ItemStack metal1, ItemStack metal2, ItemStack powder, int plan) {
        if (AmmoPressBuildPlans.isValidFor(metal1, 0) && AmmoPressBuildPlans.isValidFor(metal2, 1) && AmmoPressBuildPlans.isValidFor(powder, 2) && metal1.func_190916_E() >= 1 && metal2.func_190916_E() >= 2 && powder.func_190916_E() >= 1) {
            switch (plan) {
                case 0: {
                    return new ItemStack(TGItems.PISTOL_ROUNDS.func_77973_b(), 12, TGItems.PISTOL_ROUNDS.func_77952_i());
                }
                case 1: {
                    return new ItemStack(TGItems.SHOTGUN_ROUNDS.func_77973_b(), 16, TGItems.SHOTGUN_ROUNDS.func_77952_i());
                }
                case 2: {
                    return new ItemStack(TGItems.RIFLE_ROUNDS.func_77973_b(), 8, TGItems.RIFLE_ROUNDS.func_77952_i());
                }
                case 3: {
                    return new ItemStack(TGItems.SNIPER_ROUNDS.func_77973_b(), 4, TGItems.SNIPER_ROUNDS.func_77952_i());
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static IMachineRecipe getRecipeForType(int type) {
        AmmoPressMachineRecipe rec = new AmmoPressMachineRecipe(type);
        return rec;
    }

    public static class AmmoPressMachineRecipe
    implements IMachineRecipe {
        byte plan;

        public AmmoPressMachineRecipe(int plan) {
            this.plan = (byte)plan;
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            inputs.add(metal1);
            inputs.add(metal2);
            inputs.add(powder);
            return inputs;
        }

        @Override
        public List<List<ItemStack>> getItemOutputs() {
            ArrayList<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            ItemStack stack = ItemStack.field_190927_a;
            switch (this.plan) {
                case 0: {
                    stack = new ItemStack(TGItems.PISTOL_ROUNDS.func_77973_b(), 12, TGItems.PISTOL_ROUNDS.func_77952_i());
                    break;
                }
                case 1: {
                    stack = new ItemStack(TGItems.SHOTGUN_ROUNDS.func_77973_b(), 16, TGItems.SHOTGUN_ROUNDS.func_77952_i());
                    break;
                }
                case 2: {
                    stack = new ItemStack(TGItems.RIFLE_ROUNDS.func_77973_b(), 8, TGItems.RIFLE_ROUNDS.func_77952_i());
                    break;
                }
                case 3: {
                    stack = new ItemStack(TGItems.SNIPER_ROUNDS.func_77973_b(), 4, TGItems.SNIPER_ROUNDS.func_77952_i());
                }
            }
            output.add(stack);
            outputs.add(output);
            return outputs;
        }
    }
}

