/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGBlocks;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.blocks.machines.multiblocks.ReactionChamberDefinition;
import techguns.blocks.machines.multiblocks.SlavePos;
import techguns.packets.PacketSpawnParticle;
import techguns.packets.PacketUpdateTileEntTanks;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.operation.FluidTankPlus;
import techguns.tileentities.operation.ITileEntityFluidTanks;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineSlotItem;
import techguns.tileentities.operation.ReactionBeamFocus;
import techguns.tileentities.operation.ReactionChamberOperation;
import techguns.tileentities.operation.ReactionChamberRecipe;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class ReactionChamberTileEntMaster
extends MultiBlockMachineTileEntMaster
implements ITileEntityFluidTanks,
SimpleComponent {
    public FluidTank inputTank = new ReactionChamberFluidTank(this, 10000);
    public static final int CAPACITY_INPUT_TANK = 10000;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FOCUS = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int OUTPUT_SLOTS_COUNT = 4;
    public static final int BUTTON_ID_LIQUIDLEVEL_INC = 3;
    public static final int BUTTON_ID_LIQUIDLEVEL_DEC = 4;
    public static final int BUTTON_ID_INTENSITY_INC = 5;
    public static final int BUTTON_ID_INTENSTIY_DEC = 6;
    public static final int BUTTON_ID_DUMPTANK = 7;
    public static Field playerChunkMapEntry_Players = ObfuscationReflectionHelper.findField(PlayerChunkMapEntry.class, (String)"field_187283_c");
    protected byte intensity = 0;
    protected byte liquidLevel = 0;
    public MachineSlotItem input;
    public boolean fluidsChanged = false;

    public ReactionChamberTileEntMaster() {
        super(6, 1000000);
        this.inventory = new ItemStackHandlerPlus(6){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ReactionChamberTileEntMaster.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                if (slot <= 1) {
                    return ReactionChamberTileEntMaster.this.isItemValidForSlot(slot, stack);
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot >= 2 && slot < 6;
            }
        };
        this.input = new MachineSlotItem(this, 0);
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        if (slot == 0) {
            return true;
        }
        if (slot == 1) {
            return ReactionBeamFocus.getBeamFocus(item) != null;
        }
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.inputTank : super.getCapability(capability, facing));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isFormed()) {
            BlockPos p = this.func_174877_v();
            EnumFacing left = this.multiblockDirection.func_176746_e();
            BlockPos other = p.func_177967_a(this.multiblockDirection, 3).func_177967_a(left, 2).func_177967_a(EnumFacing.UP, 4);
            BlockPos first = p.func_177967_a(this.multiblockDirection.func_176734_d(), 1).func_177967_a(left.func_176734_d(), 2).func_177967_a(EnumFacing.DOWN, 1);
            return new AxisAlignedBB(first, other);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        NBTTagCompound inputTankTags = tags.func_74775_l("inputTank");
        this.inputTank.readFromNBT(inputTankTags);
        this.intensity = tags.func_74771_c("intensity");
        this.liquidLevel = tags.func_74771_c("liquidLevel");
        if (tags.func_74764_b("inputSlot")) {
            ItemStack inputSlot = new ItemStack(tags.func_74775_l("inputSlot"));
            this.inventory.setStackInSlot(0, inputSlot);
        } else {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if (tags.func_74764_b("focusSlot")) {
            ItemStack focusSlot = new ItemStack(tags.func_74775_l("focusSlot"));
            this.inventory.setStackInSlot(1, focusSlot);
        } else {
            this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
        }
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        NBTTagCompound inputTankTags = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTags);
        tags.func_74782_a("inputTank", (NBTBase)inputTankTags);
        tags.func_74774_a("intensity", this.intensity);
        tags.func_74774_a("liquidLevel", this.liquidLevel);
        if (!this.input.get().func_190926_b()) {
            NBTTagCompound inputSlot = new NBTTagCompound();
            this.input.get().func_77955_b(inputSlot);
            tags.func_74782_a("inputSlot", (NBTBase)inputSlot);
        }
        if (!this.inventory.getStackInSlot(1).func_190926_b()) {
            NBTTagCompound focusSlot = new NBTTagCompound();
            this.inventory.getStackInSlot(1).func_77955_b(focusSlot);
            tags.func_74782_a("focusSlot", (NBTBase)focusSlot);
        }
    }

    @Override
    public void readOperationFromNBT(NBTTagCompound tags) {
        this.currentOperation = tags.func_74764_b("operation") ? new ReactionChamberOperation(tags, this) : null;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.reactionchamber", new Object[0]);
    }

    @Override
    protected int getNeededPower() {
        return 0;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.fluidsChanged) {
            this.fluidsChanged = false;
            this.needFluidUpdate();
        }
        if (this.isRedstoneEnabled()) {
            ReactionChamberOperation currentReaction = this.getCurrentReaction();
            if (currentReaction != null && currentReaction.getRecipe() != null) {
                ++this.progress;
                boolean state = currentReaction.tick(this.intensity, this.liquidLevel, this.field_145850_b.field_72995_K, this, currentReaction.getRecipe().RFTick);
                if (!this.field_145850_b.field_72995_K && state) {
                    if (currentReaction.isSuccess()) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.finishedOperation();
                        }
                        this.progress = 0;
                        this.totaltime = 0;
                        this.currentOperation = null;
                        if (!this.field_145850_b.field_72995_K) {
                            this.checkAndStartOperation();
                        }
                    } else if (currentReaction.isFailure(this)) {
                        ReactionChamberRecipe.RiskType risk = currentReaction.getRecipe().risk;
                        this.progress = 0;
                        this.totaltime = 0;
                        this.currentOperation = null;
                        if (risk == ReactionChamberRecipe.RiskType.EXPLOSION_LOW) {
                            this.explode(0);
                        } else if (risk == ReactionChamberRecipe.RiskType.EXPLOSION_MEDIUM) {
                            this.explode(1);
                        }
                        if (!ReactionChamberRecipe.RiskType.isFatal(risk) && !this.field_145850_b.field_72995_K) {
                            this.checkAndStartOperation();
                        }
                    }
                    this.needUpdate();
                }
                if (this.field_145850_b.field_72995_K && this.getCurrentReaction().nextTick == 59) {
                    this.playReactionTickSound(currentReaction.required_intensity == this.intensity);
                }
            } else if (!this.field_145850_b.field_72995_K && this.contentsChanged) {
                this.checkAndStartOperation();
                if (this.currentOperation != null) {
                    this.needUpdate();
                }
            }
        }
    }

    @Override
    protected void checkAndStartOperation() {
        this.contentsChanged = false;
        ReactionChamberRecipe rec = ReactionChamberRecipe.getMatchingRecipe(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inputTank.getFluid(), this.liquidLevel, this.intensity);
        if (rec != null) {
            if (rec.RFTick <= this.energy.getEnergyStored()) {
                this.currentOperation = new ReactionChamberOperation(rec, this);
                this.input.consume(1);
                this.totaltime = rec.ticks * 60;
                this.progress = 0;
            } else {
                this.contentsChanged = true;
            }
        }
    }

    @Override
    protected void finishedOperation() {
        this.mergeOutput();
    }

    private void mergeOutput() {
        ArrayList<ItemStack> outputs = this.getCurrentReaction().getRecipe().outputs;
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = outputs.get(i).func_77946_l();
            int leftover = output.func_190916_E();
            int s = 2;
            ItemStack out = ItemStack.field_190927_a;
            while (leftover > 0 && s < 6) {
                out = this.inventory.insertItemNoCheck(s, output, false);
                if (!out.func_190926_b()) {
                    leftover = out.func_190916_E();
                    if (leftover <= 0) continue;
                    output = out;
                    ++s;
                    continue;
                }
                leftover = 0;
            }
            if (leftover <= 0) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, out));
        }
        if (this.getCurrentReaction().getRecipe().liquidConsumtion > 0) {
            ((ReactionChamberFluidTank)this.inputTank).removeInternal(this.getCurrentReaction().getRecipe().liquidConsumtion);
        }
    }

    @Override
    protected void playAmbientSound() {
    }

    protected void playReactionTickSound(boolean goodTick) {
        ReactionBeamFocus focus;
        ItemStack focusitem = this.inventory.getStackInSlot(1);
        BlockPos pos = this.field_174879_c.func_177972_a(this.multiblockDirection);
        if (focusitem != null && (focus = ReactionBeamFocus.getBeamFocus(focusitem)) != null) {
            this.field_145850_b.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), focus.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        Random rng = new Random();
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SPELL, (double)((float)pos.func_177958_n() + rng.nextFloat()), (double)((float)pos.func_177956_o() + rng.nextFloat()), (double)((float)pos.func_177952_p() + rng.nextFloat()), 0.0, 1.0, 0.0, new int[0]);
        }
        if (goodTick) {
            this.field_145850_b.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), TGSounds.REACTION_CHAMBER_BEEP, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        } else {
            this.field_145850_b.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), TGSounds.REACTION_CHAMBER_WARNING, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    @Override
    protected MultiBlockMachine getMachineBlockType() {
        return TGBlocks.MULTIBLOCK_MACHINE;
    }

    @Override
    public AxisAlignedBB getBBforSlave(BlockPos slavePos) {
        BlockPos center;
        SlavePos sp;
        AxisAlignedBB bb;
        if (this.multiblockDirection != null && (bb = ReactionChamberDefinition.boundingBoxes.get(sp = new SlavePos(slavePos, center = this.func_174877_v().func_177967_a(this.multiblockDirection, 1)))) != null) {
            return bb;
        }
        return Block.field_185505_j;
    }

    public int getValidSlotForItemInMachine(ItemStack stack) {
        ITGSpecialSlot itm;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ITGSpecialSlot && (itm = (ITGSpecialSlot)stack.func_77973_b()).getSlot(stack) == TGSlotType.REACTION_CHAMBER_FOCUS && ReactionBeamFocus.getBeamFocus(stack) != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean consumePower(int amount) {
        return super.consumePower(amount);
    }

    public byte getIntensity() {
        return this.intensity;
    }

    public byte getLiquidLevel() {
        return this.liquidLevel;
    }

    public void setIntensity(byte intensity) {
        this.intensity = intensity;
    }

    public void setLiquidLevel(byte liquidLevel) {
        this.liquidLevel = liquidLevel;
    }

    public ReactionChamberOperation getCurrentReaction() {
        if (this.currentOperation == null) {
            return null;
        }
        return (ReactionChamberOperation)this.currentOperation;
    }

    protected void explode(int type) {
        EnumFacing dir = this.multiblockDirection;
        if (!this.field_145850_b.field_72995_K) {
            Block fluidBlock = null;
            if (this.inputTank.getFluid() != null) {
                fluidBlock = this.inputTank.getFluid().getFluid().getBlock();
            }
            BlockPos masterPos = this.func_174877_v().func_185334_h();
            BlockPos centerPos = masterPos.func_177972_a(dir).func_177984_a();
            this.onMultiBlockBreak();
            this.field_145850_b.func_175698_g(centerPos);
            ArrayList<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
            if (type == 0) {
                blocksToRemove.add(centerPos.func_177972_a(EnumFacing.SOUTH));
                blocksToRemove.add(centerPos.func_177972_a(EnumFacing.NORTH));
                blocksToRemove.add(centerPos.func_177972_a(EnumFacing.WEST));
                blocksToRemove.add(centerPos.func_177972_a(EnumFacing.EAST));
            } else if (type == 1) {
                BlockPos pos = masterPos.func_185334_h();
                EnumFacing left = dir.func_176746_e();
                BlockPos pos1 = pos.func_177972_a(left).func_177984_a();
                BlockPos pos2 = pos.func_177972_a(left.func_176734_d()).func_177967_a(dir, 2).func_177981_b(2);
                BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2).forEach(p -> blocksToRemove.add((BlockPos)p));
            }
            if (type == 0 && fluidBlock != null) {
                this.field_145850_b.func_180501_a(centerPos, fluidBlock.func_176223_P(), 3);
            } else if (type == 0) {
                this.field_145850_b.func_180501_a(centerPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            blocksToRemove.forEach(b -> this.field_145850_b.func_180501_a(b, Blocks.field_150350_a.func_176223_P(), 3));
            if (type == 0) {
                TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("FragGrenadeExplosion", (double)centerPos.func_177958_n() + 0.5, (double)centerPos.func_177956_o() + 0.5, (double)centerPos.func_177952_p() + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)centerPos.func_177958_n() + 0.5, (double)centerPos.func_177956_o() + 0.5, (double)centerPos.func_177952_p() + 0.5, 50.0));
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)centerPos.func_177958_n() + 0.5, (double)centerPos.func_177956_o() + 0.5, (double)centerPos.func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            } else if (type == 1) {
                this.field_145850_b.func_72876_a(null, (double)centerPos.func_177958_n() + 0.5, (double)centerPos.func_177956_o() + 0.5, (double)centerPos.func_177952_p() + 0.5, 4.0f, true);
            }
            if (type == 1 && fluidBlock != null) {
                this.field_145850_b.func_180501_a(centerPos, fluidBlock.func_176223_P(), 3);
                this.field_145850_b.func_180501_a(centerPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 3);
                this.field_145850_b.func_180501_a(centerPos.func_177977_b(), Blocks.field_150351_n.func_176223_P(), 3);
            }
            this.energy.setEnergyStored(0);
            this.inputTank.setFluid(null);
            ItemStack content = this.input.get();
            if (!content.func_190926_b()) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)centerPos.func_177958_n() + 0.5, (double)centerPos.func_177956_o() + 0.5, (double)centerPos.func_177952_p() + 0.5, content));
            }
            this.needUpdate();
        }
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id <= 2) {
            super.buttonClicked(id, ply, data);
        } else if (this.isUseableByPlayer(ply)) {
            switch (id) {
                case 3: {
                    if (this.liquidLevel >= 10) break;
                    this.liquidLevel = (byte)(this.liquidLevel + 1);
                    this.contentsChanged = true;
                    break;
                }
                case 4: {
                    if (this.liquidLevel <= 0) break;
                    this.liquidLevel = (byte)(this.liquidLevel - 1);
                    this.contentsChanged = true;
                    break;
                }
                case 5: {
                    if (this.intensity >= 10) break;
                    this.intensity = (byte)(this.intensity + 1);
                    this.contentsChanged = true;
                    break;
                }
                case 6: {
                    if (this.intensity <= 0) break;
                    this.intensity = (byte)(this.intensity - 1);
                    this.contentsChanged = true;
                    break;
                }
                case 7: {
                    this.dumpLiquid();
                }
            }
        }
    }

    private void dumpLiquid() {
        this.inputTank.setFluid(null);
        this.contentsChanged = true;
        this.needUpdate();
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.formed) {
            if (pass == 1 && this.inputTank.getFluidAmount() > 0) {
                return true;
            }
            return pass == 0 && this.isWorking();
        }
        return false;
    }

    @Override
    public void saveTanksToNBT(NBTTagCompound tags) {
        NBTTagCompound inputTankTags = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTags);
        tags.func_74782_a("inputTank", (NBTBase)inputTankTags);
    }

    @Override
    public void loadTanksFromNBT(NBTTagCompound tags) {
        NBTTagCompound inputTank = tags.func_74775_l("inputTank");
        this.inputTank.readFromNBT(inputTank);
    }

    public void needFluidUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ChunkPos cp = this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l();
            PlayerChunkMapEntry entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(cp.field_77276_a, cp.field_77275_b);
            if (entry != null) {
                try {
                    List players = (List)playerChunkMapEntry_Players.get(entry);
                    PacketUpdateTileEntTanks packet = new PacketUpdateTileEntTanks(this, this.func_174877_v());
                    for (EntityPlayerMP entityplayermp : players) {
                        TGPackets.network.sendTo((IMessage)packet, entityplayermp);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "tg2_reactionchamber";
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(int:liquidLimit):boolean -- sets the liquid limit for the input tank", direct=false)
    public Object[] setLiquidLevel(Context context, Arguments args) {
        if (args.count() < 1) {
            return new Object[]{false, "no liquid level specified"};
        }
        byte newLiquidLevel = (byte)Math.max(0, Math.min(args.checkInteger(0), 10));
        this.setLiquidLevel(newLiquidLevel);
        return new Object[]{this.getLiquidLevel() == newLiquidLevel};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():int -- returns the liquid limit", direct=false)
    public Object[] getLiquidLevel(Context context, Arguments args) {
        return new Object[]{this.getLiquidLevel()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(int:intensity):boolean -- sets the intensity level", direct=false)
    public Object[] setIntensity(Context context, Arguments args) {
        if (args.count() < 1) {
            return new Object[]{false, "no intensity level specified"};
        }
        byte newIntensity = (byte)Math.max(0, Math.min(args.checkInteger(0), 10));
        this.setIntensity(newIntensity);
        return new Object[]{this.getIntensity() == newIntensity};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():int -- returns the intensity level", direct=false)
    public Object[] getIntensity(Context context, Arguments args) {
        return new Object[]{this.getIntensity()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():boolean -- dumps the liquid in the input tank", direct=false)
    public Object[] dumpLiquid(Context context, Arguments args) {
        this.dumpLiquid();
        return new Object[]{this.inputTank.getFluid() == null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():boolean -- returns the stored energy", direct=false)
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getEnergyStorage().getEnergyStored()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():boolean -- returns the size of the internal energy buffer", direct=false)
    public Object[] getMaxEnergyStored(Context context, Arguments args) {
        return new Object[]{this.getEnergyStorage().getMaxEnergyStored()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():table -- returns statistics about the current reaction", direct=false)
    public Object[] getReactionStats(Context context, Arguments args) {
        HashMap<String, Comparable<Boolean>> data = new HashMap<String, Comparable<Boolean>>();
        data.put("validRecipe", Boolean.valueOf(this.getCurrentReaction() != null));
        if (this.getCurrentReaction() != null) {
            data.put("preferedIntensity", Integer.valueOf(this.getCurrentReaction().getCurrentPreferedIntensity()));
            data.put("progress", Integer.valueOf(this.progress));
            data.put("duration", Integer.valueOf(this.totaltime));
            data.put("energyPerTick", Integer.valueOf(this.getCurrentReaction().getPowerPerTick()));
        }
        return new Object[]{data};
    }

    protected class ReactionChamberFluidTank
    extends FluidTankPlus {
        protected ReactionChamberTileEntMaster tile;

        public ReactionChamberFluidTank(ReactionChamberTileEntMaster tile, int capacity) {
            super(tile, capacity);
            this.setTileEntity(tile);
            this.tile = tile;
        }

        private int getFillCapacity() {
            return this.tile.liquidLevel * 1000;
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            this.tile.fluidsChanged = true;
        }

        @Override
        public int fillInternal(FluidStack resource, boolean doFill) {
            int fillCapacity = this.getFillCapacity();
            if (resource == null || resource.amount <= 0) {
                return 0;
            }
            if (!doFill) {
                if (this.fluid == null) {
                    return Math.min(fillCapacity, resource.amount);
                }
                if (!this.fluid.isFluidEqual(resource)) {
                    return 0;
                }
                return Math.min(fillCapacity - this.fluid.amount, resource.amount);
            }
            if (this.fluid == null) {
                this.fluid = new FluidStack(resource, Math.min(fillCapacity, resource.amount));
                this.onContentsChanged();
                if (this.tile != null) {
                    FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, this.fluid.amount));
                }
                return this.fluid.amount;
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            int filled = fillCapacity - this.fluid.amount;
            if (resource.amount < filled) {
                this.fluid.amount += resource.amount;
                filled = resource.amount;
            } else {
                this.fluid.amount = fillCapacity;
            }
            if (filled > 0) {
                this.onContentsChanged();
            }
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, filled));
            }
            return filled;
        }

        void removeInternal(int amount) {
            if (this.fluid != null) {
                this.fluid.amount -= amount;
                if (this.fluid.amount <= 0) {
                    this.fluid = null;
                }
            }
        }

        public FluidStack drainInternal(int maxDrain, boolean doDrain) {
            int maxDrainAmount = Math.max(this.fluid.amount - this.tile.liquidLevel * 1000, 0);
            int drainAmount = Math.min(maxDrainAmount, maxDrain);
            if (this.fluid == null || drainAmount <= 0) {
                return null;
            }
            int drained = drainAmount;
            if (this.fluid.amount < drained) {
                drained = this.fluid.amount;
            }
            FluidStack stack = new FluidStack(this.fluid, drained);
            if (doDrain) {
                this.fluid.amount -= drained;
                if (this.fluid.amount <= 0) {
                    this.fluid = null;
                }
                this.onContentsChanged();
                if (this.tile != null) {
                    FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, drained));
                }
            }
            return stack;
        }
    }
}

