/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.tileentities.MultiBlockMachineTileEntMaster;

public abstract class MultiBlockMachineTileEntSlave
extends TileEntity {
    protected int masterX;
    protected int masterY;
    protected int masterZ;
    protected boolean hasMaster;
    protected byte type = 0;
    private MultiBlockMachineTileEntMaster masterTileEnt = null;

    protected MultiBlockMachineTileEntMaster getMaster() {
        if (this.hasMaster) {
            if (this.masterTileEnt == null) {
                TileEntity tile = this.field_145850_b.func_175625_s(new BlockPos(this.masterX, this.masterY, this.masterZ));
                if (tile != null && tile instanceof MultiBlockMachineTileEntMaster) {
                    this.masterTileEnt = (MultiBlockMachineTileEntMaster)tile;
                    return this.masterTileEnt;
                }
            } else {
                return this.masterTileEnt;
            }
        }
        return null;
    }

    public void unform() {
        this.hasMaster = false;
        this.masterTileEnt = null;
        this.setType((byte)0);
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void form(BlockPos masterPos, byte type) {
        this.hasMaster = true;
        this.masterX = masterPos.func_177958_n();
        this.masterY = masterPos.func_177956_o();
        this.masterZ = masterPos.func_177952_p();
        this.type = type;
    }

    public int getSlaveType() {
        return this.type;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        this.writeClientDataToNBT(tags);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tags);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readClientDataFromNBT(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        this.writeClientDataToNBT(tags);
        return tags;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readClientDataFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeClientDataToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readClientDataFromNBT(compound);
        super.func_145839_a(compound);
    }

    public void writeClientDataToNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.func_74768_a("masterX", this.masterX);
            tags.func_74768_a("masterY", this.masterY);
            tags.func_74768_a("masterZ", this.masterZ);
            tags.func_74774_a("type", this.type);
        }
    }

    public void readClientDataFromNBT(NBTTagCompound tags) {
        this.hasMaster = tags.func_74767_n("hasMaster");
        if (this.hasMaster) {
            this.masterX = tags.func_74762_e("masterX");
            this.masterY = tags.func_74762_e("masterY");
            this.masterZ = tags.func_74762_e("masterZ");
            this.type = tags.func_74771_c("type");
        } else {
            this.type = 0;
        }
    }

    public boolean hasMaster() {
        return this.hasMaster;
    }

    public void onBlockBreak() {
        if (!this.field_145850_b.field_72995_K && this.hasMaster) {
            this.getMaster().onMultiBlockBreak();
        }
    }

    public BlockPos getMasterPos() {
        return new BlockPos(this.masterX, this.masterY, this.masterZ);
    }

    public void needUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ChunkPos cp = this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l();
            PlayerChunkMapEntry entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(cp.field_77276_a, cp.field_77275_b);
            if (entry != null) {
                entry.func_187267_a((Packet)this.func_189518_D_());
            }
        }
        this.func_70296_d();
    }

    public abstract MultiBlockMachine getMachineBlockType();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b((IProperty)this.getMachineBlockType().MACHINE_TYPE) != newState.func_177229_b((IProperty)this.getMachineBlockType().MACHINE_TYPE);
    }

    public AxisAlignedBB getFormedCollisionBoundingBox() {
        return Block.field_185505_j;
    }
}

