/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.machines.BasicMachine;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.blocks.machines.multiblocks.MultiBlockMachineSchematic;
import techguns.blocks.machines.multiblocks.MultiBlockRegister;
import techguns.tileentities.BasicMachineTileEnt;

public abstract class MultiBlockMachineTileEntMaster
extends BasicMachineTileEnt {
    protected boolean formed = false;
    protected EnumFacing multiblockDirection;

    public MultiBlockMachineTileEntMaster(int inventorySize, int maximumPower) {
        super(inventorySize, false, maximumPower);
    }

    public EnumFacing getMultiblockDirection() {
        return this.multiblockDirection;
    }

    public boolean isFormed() {
        return this.formed;
    }

    @Override
    protected boolean enabled() {
        return this.isFormed();
    }

    @Override
    protected BasicMachine getMachineBlockType() {
        return TGBlocks.ORE_DRILL_BLOCK;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.formed = tags.func_74767_n("formed");
        if (this.formed) {
            this.multiblockDirection = EnumFacing.func_82600_a((int)tags.func_74771_c("multiblockDirection"));
        }
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74757_a("formed", this.formed);
        if (this.formed) {
            tags.func_74774_a("multiblockDirection", (byte)this.multiblockDirection.func_176745_a());
        }
    }

    @Override
    public void onBlockBreak() {
        super.onBlockBreak();
        this.onMultiBlockBreak();
    }

    @Override
    public boolean canBeWrenchRotated() {
        return false;
    }

    @Override
    public boolean canBeWrenchDismantled() {
        return false;
    }

    public void onMultiBlockBreak() {
        MultiBlockMachineSchematic multiblock;
        if (!this.field_145850_b.field_72995_K && this.formed && (multiblock = MultiBlockRegister.REGISTER.get(this.getClass())) != null) {
            multiblock.unform(this.field_145850_b, this);
        }
    }

    public void form(EnumFacing facing) {
        this.formed = true;
        if (!this.field_145850_b.field_72995_K) {
            this.multiblockDirection = facing;
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(true)), 3);
            this.needUpdate();
        }
    }

    public void unform() {
        IBlockState bs;
        this.formed = false;
        if (!this.field_145850_b.field_72995_K && (bs = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() == this.getMachineBlockType()) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b(this.getMachineBlockType().MACHINE_TYPE) != newState.func_177229_b(this.getMachineBlockType().MACHINE_TYPE);
    }

    public abstract AxisAlignedBB getBBforSlave(BlockPos var1);
}

