/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import techguns.TGBlocks;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.operation.FabricatorRecipe;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineSlotItem;

public class FabricatorTileEntMaster
extends MultiBlockMachineTileEntMaster {
    protected static final float SOUND_VOLUME = 0.5f;
    public static final int SLOT_INPUT1 = 0;
    public static final int SLOT_WIRES = 1;
    public static final int SLOT_POWDER = 2;
    public static final int SLOT_PLATE = 3;
    public static final int SLOT_OUTPUT = 4;
    public static final int SLOT_UPGRADE = 5;
    public MachineSlotItem input = new MachineSlotItem(this, 0);
    public MachineSlotItem wireslot = new MachineSlotItem(this, 1);
    public MachineSlotItem powderslot = new MachineSlotItem(this, 2);
    public MachineSlotItem plateslot = new MachineSlotItem(this, 3);
    public static final int powerPerTick = 80;

    public FabricatorTileEntMaster() {
        super(6, 100000);
        this.inventory = new ItemStackHandlerPlus(6){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                FabricatorTileEntMaster.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return FabricatorTileEntMaster.this.isItemValidForSlot(slot, stack);
                    }
                    case 4: {
                        return false;
                    }
                    case 5: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot == 4;
            }
        };
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.getValidSlotForItemInMachine(stack) == slot;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.fabricator", new Object[0]);
    }

    @Override
    public int getNeededPower() {
        return 80;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isFormed()) {
            BlockPos p = this.func_174877_v();
            EnumFacing left = this.multiblockDirection.func_176746_e();
            BlockPos other = p.func_177967_a(this.multiblockDirection, 2).func_177967_a(left, 2).func_177967_a(EnumFacing.UP, 2);
            BlockPos first = p.func_177967_a(this.multiblockDirection.func_176734_d(), 2).func_177967_a(left.func_176734_d(), 1).func_177967_a(EnumFacing.DOWN, 1);
            return new AxisAlignedBB(first, other);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    protected void checkAndStartOperation() {
        this.contentsChanged = false;
        FabricatorRecipe.RecipeData data = FabricatorRecipe.getRecipeDataFor(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2), this.inventory.getStackInSlot(3), this.getMaxMachineUpgradeMultiplier(5), this.inventory.getStackInSlot(4));
        if (data != null) {
            this.currentOperation = data.createOperation(this);
            this.input.consume(data.inputConsumption * data.stackMultiplier);
            this.wireslot.consume(data.wireConsumption * data.stackMultiplier);
            this.powderslot.consume(data.powderConsumption * data.stackMultiplier);
            this.plateslot.consume(data.plateConsumption * data.stackMultiplier);
            this.totaltime = 100;
            this.progress = 0;
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    @Override
    protected void finishedOperation() {
        ItemStack itemOut = this.currentOperation.getItemOutput0();
        if (!itemOut.func_190926_b()) {
            if (!this.inventory.getStackInSlot(4).func_190926_b()) {
                this.inventory.insertItemNoCheck(4, itemOut, false);
            } else {
                this.inventory.setStackInSlot(4, itemOut);
            }
        }
    }

    @Override
    protected void playAmbientSound() {
        if (this.field_145850_b.field_72995_K && this.progress == 1) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), TGSounds.FABRICATOR_WORK, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
    }

    @Override
    protected MultiBlockMachine getMachineBlockType() {
        return TGBlocks.MULTIBLOCK_MACHINE;
    }

    public int getValidSlotForItemInMachine(ItemStack stack) {
        if (FabricatorRecipe.itemStackInList(FabricatorRecipe.items_wireslot, stack)) {
            return 1;
        }
        if (FabricatorRecipe.itemStackInList(FabricatorRecipe.items_powderslot, stack)) {
            return 2;
        }
        if (FabricatorRecipe.itemStackInList(FabricatorRecipe.items_plateslot, stack)) {
            return 3;
        }
        if (TGItems.isMachineUpgrade(stack)) {
            return 5;
        }
        return 0;
    }

    @Override
    public AxisAlignedBB getBBforSlave(BlockPos slavePos) {
        return Block.field_185505_j;
    }
}

