/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;

public class BasicTGTileEntity
extends TileEntity {
    protected boolean hasRotation;
    public byte rotation = 0;

    public BasicTGTileEntity(boolean hasRotation) {
        this.hasRotation = hasRotation;
    }

    protected int getUseRangeSquared() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= (double)this.getUseRangeSquared();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        this.writeClientDataToNBT(tags);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tags);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readClientDataFromNBT(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        this.writeClientDataToNBT(tags);
        return tags;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readClientDataFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeClientDataToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readClientDataFromNBT(compound);
        super.func_145839_a(compound);
    }

    public void writeClientDataToNBT(NBTTagCompound tags) {
        if (this.hasRotation) {
            tags.func_74774_a("rotation", this.rotation);
        }
    }

    public void readClientDataFromNBT(NBTTagCompound tags) {
        if (this.hasRotation) {
            this.rotation = (byte)(tags.func_74771_c("rotation") % 4);
        }
    }

    public boolean hasRotation() {
        return this.hasRotation;
    }

    public void rotateTile() {
        if (!this.field_145850_b.field_72995_K && this.hasRotation) {
            this.rotation = (byte)(this.rotation + 1);
            this.needUpdate();
        }
    }

    public void rotateTile(EnumFacing sideHit) {
        this.rotateTile();
    }

    public boolean canBeWrenchRotated() {
        return true;
    }

    public boolean canBeWrenchDismantled() {
        return true;
    }

    public void needUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ChunkPos cp = this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l();
            PlayerChunkMapEntry entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(cp.field_77276_a, cp.field_77275_b);
            if (entry != null) {
                entry.func_187267_a((Packet)this.func_189518_D_());
            }
        }
        this.func_70296_d();
    }
}

