/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.tileentities.BasicOwnedTileEnt;

public abstract class BasicRedstoneTileEnt
extends BasicOwnedTileEnt {
    protected byte redstoneBehaviour = 0;
    protected boolean hasSignal = false;

    public BasicRedstoneTileEnt(int inventorySize, boolean hasRotation) {
        super(inventorySize, hasRotation);
    }

    public void onNeighborBlockChange() {
        if (!this.field_145850_b.field_72995_K) {
            boolean signal;
            int signal_str = this.field_145850_b.func_175687_A(this.field_174879_c);
            boolean bl = signal = signal_str > 0;
            if (signal != this.hasSignal) {
                this.hasSignal = signal;
                this.needUpdate();
            }
        }
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneBehaviour == 0 || this.hasSignal && this.redstoneBehaviour == 1 || !this.hasSignal && this.redstoneBehaviour == 2;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.hasSignal = tags.func_74767_n("hasSignal");
        this.redstoneBehaviour = tags.func_74771_c("redstoneBehaviour");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74757_a("hasSignal", this.hasSignal);
        tags.func_74774_a("redstoneBehaviour", this.redstoneBehaviour);
    }

    @SideOnly(value=Side.CLIENT)
    public String getRedstoneModeText() {
        switch (this.redstoneBehaviour) {
            case 0: {
                return "techguns.redstonemode.ignore";
            }
            case 1: {
                return "techguns.redstonemode.high";
            }
            case 2: {
                return "techguns.redstonemode.low";
            }
        }
        return "invalid";
    }

    @SideOnly(value=Side.CLIENT)
    public String getSignalStateText() {
        if (this.hasSignal) {
            return "techguns.redstonemode.signal.high";
        }
        return "techguns.redstonemode.signal.low";
    }

    public byte getRedstoneBehaviour() {
        return this.redstoneBehaviour;
    }

    public void setRedstoneBehaviour(byte redstoneBehaviour) {
        this.redstoneBehaviour = redstoneBehaviour;
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id == 2 && this.isUseableByPlayer(ply)) {
            this.redstoneBehaviour = (byte)(this.redstoneBehaviour + 1);
            this.redstoneBehaviour = (byte)(this.redstoneBehaviour % 3);
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
        super.buttonClicked(id, ply, data);
    }
}

