/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import techguns.TGConfig;
import techguns.tileentities.BasicRedstoneTileEnt;
import techguns.tileentities.EnergyStoragePlus;

public abstract class BasicPoweredTileEnt
extends BasicRedstoneTileEnt {
    protected EnergyStoragePlus energy;

    public BasicPoweredTileEnt(int inventorySize, boolean hasRotation, int maximumPower) {
        super(inventorySize, hasRotation);
        this.energy = new EnergyStoragePlus(maximumPower);
    }

    public EnergyStoragePlus getEnergyStorage() {
        return this.energy;
    }

    protected boolean consumePower(int amount) {
        if (TGConfig.machinesNeedNoPower) {
            return true;
        }
        if (this.energy.extractEnergy(amount, true) >= amount) {
            return this.energy.extractEnergy(amount, false) >= amount;
        }
        return false;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.energy.setEnergyStored(tags.func_74762_e("powerStored"));
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74768_a("powerStored", this.energy.getEnergyStored());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)((Object)(capability == CapabilityEnergy.ENERGY ? this.energy : super.getCapability(capability, facing)));
    }
}

