/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IStackHelper;
import techguns.TGConfig;
import techguns.TGOreClusters;
import techguns.Techguns;
import techguns.blocks.EnumOreClusterType;
import techguns.gui.TGBaseGui;
import techguns.plugins.jei.BasicRecipeWrapper;
import techguns.plugins.jei.OreDrillMachineRecipe;
import techguns.util.TextUtil;

public class OreDrillJeiRecipe
extends BasicRecipeWrapper {
    protected final OreDrillMachineRecipe mr;

    public OreDrillJeiRecipe(OreDrillMachineRecipe recipe) {
        super(recipe);
        this.mr = recipe;
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (TGBaseGui.isInRect(mouseX, mouseY, 0, 1, 6, 60)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            TGOreClusters.OreCluster cluster = Techguns.orecluster.getClusterForType(this.mr.getType());
            double ore_per_hour = 4.5 * cluster.getMultiplier_amount() * (double)TGConfig.oreDrillMultiplierOres;
            int powerTick = (int)(8.0 * ore_per_hour * cluster.getMultiplier_power() * (double)TGConfig.oreDrillMultiplierPower);
            tooltip.add(TextUtil.transTG("oredrill.powerperore") + ": ");
            tooltip.add((int)((double)(powerTick * 20 * 60 * 60) / ore_per_hour) + " " + "FE");
            return tooltip;
        }
        return Collections.emptyList();
    }

    @Override
    protected int getRFperTick() {
        return 0;
    }

    public float getChance() {
        return this.mr.getChance();
    }

    public static List<OreDrillJeiRecipe> getRecipes(IJeiHelpers helpers, IIngredientRegistry registry) {
        IStackHelper stackHelper = helpers.getStackHelper();
        ArrayList<OreDrillJeiRecipe> recipes = new ArrayList<OreDrillJeiRecipe>();
        for (EnumOreClusterType type : EnumOreClusterType.values()) {
            TGOreClusters.OreCluster cluster = Techguns.orecluster.getClusterForType(type);
            ArrayList<TGOreClusters.OreClusterWeightedEntry> entries = cluster.getOreEntries();
            for (TGOreClusters.OreClusterWeightedEntry we : entries) {
                recipes.add(new OreDrillJeiRecipe(new OreDrillMachineRecipe(we, type, registry.getFuels())));
            }
        }
        return recipes;
    }
}

