/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import techguns.gui.GrinderGui;
import techguns.plugins.jei.BasicRecipeCategory;
import techguns.plugins.jei.GrinderJeiRecipe;
import techguns.tileentities.operation.GrinderRecipes;
import techguns.util.TextUtil;

public class GrinderRecipeCategory
extends BasicRecipeCategory<GrinderJeiRecipe> {
    IDrawableStatic progress1_static;
    IDrawableAnimated progress1;
    IDrawableStatic progress2_static;
    IDrawableAnimated progress2;

    public GrinderRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, GrinderGui.texture, "grinder", "techguns.grinder");
        this.progress1_static = guiHelper.createDrawable(GrinderGui.texture, 0, 167, 21, 21);
        this.progress1 = guiHelper.createAnimatedDrawable(this.progress1_static, 100, IDrawableAnimated.StartDirection.LEFT, false);
        this.progress2_static = guiHelper.createDrawable(GrinderGui.texture, 0, 167, 21, 21);
        this.progress2 = guiHelper.createAnimatedDrawable(this.progress2_static, 100, IDrawableAnimated.StartDirection.RIGHT, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, GrinderJeiRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 10, 1);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                guiItemStacks.init(2 + i * 3 + j, false, 80 + j * 18 + -8, 1 + i * 18);
            }
        }
        guiItemStacks.addTooltipCallback((ITooltipCallback)new GrinderOutputTooltipCallback(recipeWrapper));
        guiItemStacks.set(ingredients);
    }

    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.powerbar.draw(minecraft, 0, 1);
        this.progress1.draw(minecraft, 24, 24);
        this.progress2.draw(minecraft, 44, 24);
    }

    protected class GrinderOutputTooltipCallback
    implements ITooltipCallback<ItemStack> {
        GrinderJeiRecipe jeiRec;

        public GrinderOutputTooltipCallback(GrinderJeiRecipe jeiRec) {
            this.jeiRec = jeiRec;
        }

        public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
            GrinderRecipes.GrinderRecipeChance r;
            if (!input && this.jeiRec.rec instanceof GrinderRecipes.GrinderRecipeChance && (r = (GrinderRecipes.GrinderRecipeChance)this.jeiRec.rec).getChances()[slotIndex - 2] < 1.0) {
                tooltip.add(tooltip.size() - 1, TextUtil.transTG("oredrill.jei.chance") + ": " + String.format("%.2f", r.getChances()[slotIndex - 2] * 100.0) + "%");
            }
        }
    }
}

