/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.plugins.crafttweaker.TGCraftTweakerHelper;
import techguns.tileentities.operation.FabricatorRecipe;
import techguns.util.ItemStackOreDict;
import techguns.util.ItemUtil;

@ZenClass(value="mods.techguns.Fabricator")
public class FabricatorTweaker {
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, IItemStack wire, int amount_wire, IItemStack powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, IItemStack wire, int amount_wire, IItemStack powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, IItemStack wire, int amount_wire, String powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, IItemStack wire, int amount_wire, String powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, String wire, int amount_wire, IItemStack powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, String wire, int amount_wire, IItemStack powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, String wire, int amount_wire, String powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, int amount, String wire, int amount_wire, String powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, IItemStack wire, int amount_wire, IItemStack powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, IItemStack wire, int amount_wire, IItemStack powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, IItemStack wire, int amount_wire, String powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, IItemStack wire, int amount_wire, String powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, String wire, int amount_wire, IItemStack powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, String wire, int amount_wire, IItemStack powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, String wire, int amount_wire, String powder, int amount_powder, IItemStack plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    @ZenMethod
    public static void addRecipe(String input, int amount, String wire, int amount_wire, String powder, int amount_powder, String plate, int amount_plate, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), amount, TGCraftTweakerHelper.toItemStackOreDict(wire), amount_wire, TGCraftTweakerHelper.toItemStackOreDict(powder), amount_powder, TGCraftTweakerHelper.toItemStackOreDict(plate), amount_plate, output));
    }

    private static boolean checkLists(ItemStackOreDict item, byte slotId) {
        boolean checkWire = FabricatorTweaker.checkInList(FabricatorRecipe.items_wireslot, item);
        boolean checkPowder = FabricatorTweaker.checkInList(FabricatorRecipe.items_powderslot, item);
        boolean checkPlate = FabricatorTweaker.checkInList(FabricatorRecipe.items_plateslot, item);
        if (!(checkWire || checkPowder || checkPlate)) {
            switch (slotId) {
                case 0: {
                    FabricatorRecipe.items_wireslot.add(item);
                    break;
                }
                case 1: {
                    FabricatorRecipe.items_powderslot.add(item);
                    break;
                }
                case 2: {
                    FabricatorRecipe.items_plateslot.add(item);
                }
            }
            return true;
        }
        return checkWire && slotId == 0 && !checkPowder && !checkPlate || checkPowder && slotId == 1 && !checkWire && !checkPlate || checkPlate && slotId == 2 && !checkWire && !checkPowder;
    }

    private static boolean checkInList(ArrayList<ItemStackOreDict> list, ItemStackOreDict item) {
        for (ItemStackOreDict it : list) {
            if (!it.matches(item)) continue;
            return true;
        }
        return false;
    }

    private static void removeFromLists(ItemStackOreDict wire, ItemStackOreDict powder, ItemStackOreDict plate) {
        if (FabricatorTweaker.checkListRemoval(0, wire)) {
            FabricatorTweaker.removeFromList(FabricatorRecipe.items_wireslot, wire);
        }
        if (FabricatorTweaker.checkListRemoval(1, powder)) {
            FabricatorTweaker.removeFromList(FabricatorRecipe.items_powderslot, powder);
        }
        if (FabricatorTweaker.checkListRemoval(2, plate)) {
            FabricatorTweaker.removeFromList(FabricatorRecipe.items_plateslot, plate);
        }
    }

    private static void removeFromList(ArrayList<ItemStackOreDict> list, ItemStackOreDict item) {
        Iterator<ItemStackOreDict> it = list.iterator();
        while (it.hasNext()) {
            ItemStackOreDict i = it.next();
            if (!i.matches(item)) continue;
            it.remove();
        }
    }

    private static boolean checkListRemoval(int slot, ItemStackOreDict wire) {
        ArrayList<FabricatorRecipe> rec = FabricatorRecipe.getRecipes();
        for (int i = 0; i < rec.size(); ++i) {
            if (!(slot == 0 ? rec.get((int)i).wireSlot.matches(wire) : (slot == 1 ? rec.get((int)i).powderSlot.matches(wire) : slot == 2 && rec.get((int)i).plateSlot.matches(wire)))) continue;
            return false;
        }
        return true;
    }

    private static class removeInputAction
    implements IAction {
        ItemStack output;

        public removeInputAction(IItemStack output) {
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            Iterator<FabricatorRecipe> iter = FabricatorRecipe.getRecipes().iterator();
            while (iter.hasNext()) {
                FabricatorRecipe rec = iter.next();
                if (!ItemUtil.isItemEqual(rec.outputItem, this.output)) continue;
                iter.remove();
                FabricatorTweaker.removeFromLists(rec.wireSlot, rec.powderSlot, rec.plateSlot);
            }
        }

        public String describe() {
            return "Removed Recipe(s) for " + this.output + " from Fabricator";
        }
    }

    private static class addInputAction
    implements IAction {
        FabricatorRecipe added_recipe = null;
        ItemStackOreDict input;
        int amount;
        ItemStackOreDict input_wire;
        int amount_wire;
        ItemStackOreDict input_powder;
        int amount_powder;
        ItemStackOreDict input_plate;
        int amount_plate;
        ItemStack output;
        boolean warning = false;

        public addInputAction(ItemStackOreDict input, int amount, ItemStackOreDict input_wire, int amount_wire, ItemStackOreDict input_powder, int amount_powder, ItemStackOreDict input_plate, int amount_plate, IItemStack output) {
            this.input = input;
            this.amount = amount;
            this.input_wire = input_wire;
            this.amount_wire = amount_wire;
            this.input_powder = input_powder;
            this.amount_powder = amount_powder;
            this.input_plate = input_plate;
            this.amount_plate = amount_plate;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            if (amount_wire <= 0) {
                this.input_wire = ItemStackOreDict.EMPTY;
            }
            if (amount_powder <= 0) {
                this.input_powder = ItemStackOreDict.EMPTY;
            }
            if (!FabricatorTweaker.checkLists(input_wire, (byte)0)) {
                this.warning = true;
            }
            if (!FabricatorTweaker.checkLists(input_powder, (byte)1)) {
                this.warning = true;
            }
            if (!FabricatorTweaker.checkLists(input_plate, (byte)2)) {
                this.warning = true;
            }
        }

        public void apply() {
            this.added_recipe = new FabricatorRecipe(this.input, this.amount, this.input_wire, this.amount_wire, this.input_powder, this.amount_powder, this.input_plate, this.amount_plate, this.output, this.output.func_190916_E());
            FabricatorRecipe.getRecipes().add(this.added_recipe);
        }

        public String describe() {
            if (!this.warning) {
                return "Add Recipe for " + this.output + " to Fabricator";
            }
            return "WARNING while adding Fabricator Recipe for " + this.output + ": One input already in use in another slot by other recipes! THIS WILL NOT WORK!";
        }
    }
}

