/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.plugins.crafttweaker.TGCraftTweakerHelper;
import techguns.tileentities.operation.ChemLabRecipes;
import techguns.util.ItemStackOreDict;
import techguns.util.ItemUtil;

@ZenClass(value="mods.techguns.ChemLab")
public class ChemLabTweaker {
    @ZenMethod
    public static void addRecipe(String input1, int amount1, String input2, int amount2, ILiquidStack fluidIn, boolean allowSwap, IItemStack output, ILiquidStack fluidOut, int rfTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), amount1, TGCraftTweakerHelper.toItemStackOreDict(input2), amount2, fluidIn, allowSwap, output, fluidOut, rfTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input1, int amount1, String input2, int amount2, ILiquidStack fluidIn, boolean allowSwap, IItemStack output, ILiquidStack fluidOut, int rfTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), amount1, TGCraftTweakerHelper.toItemStackOreDict(input2), amount2, fluidIn, allowSwap, output, fluidOut, rfTick));
    }

    @ZenMethod
    public static void addRecipe(String input1, int amount1, IItemStack input2, int amount2, ILiquidStack fluidIn, boolean allowSwap, IItemStack output, ILiquidStack fluidOut, int rfTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), amount1, TGCraftTweakerHelper.toItemStackOreDict(input2), amount2, fluidIn, allowSwap, output, fluidOut, rfTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input1, int amount1, IItemStack input2, int amount2, ILiquidStack fluidIn, boolean allowSwap, IItemStack output, ILiquidStack fluidOut, int rfTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), amount1, TGCraftTweakerHelper.toItemStackOreDict(input2), amount2, fluidIn, allowSwap, output, fluidOut, rfTick));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, ILiquidStack fluidOut) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(output, fluidOut));
    }

    private static class removeInputAction
    implements IAction {
        ItemStackOreDict input1;
        ItemStackOreDict input2;
        FluidStack fluidIn;
        FluidStack fluidOut;
        ItemStack output;
        boolean checkInput;

        public removeInputAction(IItemStack output, ILiquidStack fluidOut) {
            this.fluidOut = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidOut);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.checkInput = false;
        }

        public removeInputAction(IItemStack output, ILiquidStack fluidOut, ItemStackOreDict input1, ItemStackOreDict input2, ILiquidStack fluidIn) {
            this.fluidOut = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidOut);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.checkInput = true;
            this.input1 = input1;
            this.input2 = input2;
            this.fluidIn = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidIn);
        }

        public void apply() {
            Iterator<ChemLabRecipes.ChemLabRecipe> iter = ChemLabRecipes.getRecipes().iterator();
            while (iter.hasNext()) {
                ChemLabRecipes.ChemLabRecipe rec = iter.next();
                if (!ItemUtil.isItemEqual(rec.output, this.output) || !ItemUtil.isFluidEqual(rec.fluidOutput, this.fluidOut)) continue;
                if (this.checkInput) {
                    if (!rec.slot1.matches(this.input1) || !rec.slot2.matches(this.input2) || !ItemUtil.isFluidEqual(rec.fluidIn, this.fluidIn)) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
        }

        public String describe() {
            return "Removed Recipe(s) for " + (this.output.func_190926_b() ? "NO_ITEM" : this.output) + "/" + (this.fluidOut == null ? "NO_FLUID" : this.fluidOut.getUnlocalizedName()) + " from ChemLab";
        }
    }

    private static class addInputAction
    implements IAction {
        ChemLabRecipes.ChemLabRecipe added_recipe = null;
        ItemStackOreDict input1;
        ItemStackOreDict input2;
        FluidStack fluidIn;
        FluidStack fluidOut;
        boolean swap;
        ItemStack output = ItemStack.field_190927_a;
        int power;
        int amount1;
        int amount2;

        public addInputAction(ItemStackOreDict input1, int amount1, ItemStackOreDict input2, int amount2, ILiquidStack fluidIn, boolean swap, IItemStack output, ILiquidStack fluidOut, int power) {
            this.input1 = input1;
            this.amount1 = amount1;
            this.input2 = input2;
            this.amount2 = amount2;
            this.fluidIn = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidIn);
            this.fluidOut = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidOut);
            this.swap = swap;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.power = power;
            if (amount2 <= 0) {
                this.input2 = ItemStackOreDict.EMPTY;
            }
            if (this.fluidIn.amount <= 0) {
                this.fluidIn = null;
            }
            if (this.fluidOut.amount <= 0) {
                this.fluidOut = null;
            }
            if (!this.output.func_190926_b() && this.output.func_190916_E() <= 0) {
                this.output = ItemStack.field_190927_a;
            }
        }

        public void apply() {
            this.added_recipe = new ChemLabRecipes.ChemLabRecipe(this.input1, this.amount1, this.input2, this.amount2, ItemStack.field_190927_a, 0, this.fluidIn, this.swap, this.output, this.fluidOut, this.power);
            ChemLabRecipes.getRecipes().add(this.added_recipe);
        }

        public String describe() {
            return "Add Recipe for" + (this.output.func_190926_b() ? "NO_ITEM" : this.output) + "/" + (this.fluidOut == null ? "NO_FLUID" : this.fluidOut.getUnlocalizedName()) + " to ChemLab";
        }
    }
}

