/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.capabilities.TGExtendedPlayer;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.TGArmorBonus;
import techguns.items.guns.GenericGun;
import techguns.packets.PacketShowKeybindConfirmMessage;
import techguns.packets.PacketTGExtendedPlayerSync;
import techguns.packets.PacketTGPlayerFieldSync;

public class PacketTGKeybindPress
implements IMessage {
    public byte buttonID;
    public EnumHand hand = EnumHand.MAIN_HAND;
    public boolean showMsg = false;

    public PacketTGKeybindPress() {
    }

    public PacketTGKeybindPress(byte buttonID) {
        this.buttonID = buttonID;
    }

    public PacketTGKeybindPress(byte buttonID, EnumHand hand) {
        this(buttonID);
        this.hand = hand;
    }

    public PacketTGKeybindPress(byte buttonID, boolean showMsg) {
        this(buttonID);
        this.showMsg = showMsg;
    }

    public void fromBytes(ByteBuf buf) {
        this.buttonID = buf.readByte();
        byte h = buf.readByte();
        this.hand = EnumHand.values()[h];
        this.showMsg = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.buttonID);
        buf.writeByte((int)((byte)this.hand.ordinal()));
        buf.writeBoolean(this.showMsg);
    }

    public static class Handler
    implements IMessageHandler<PacketTGKeybindPress, IMessage> {
        public IMessage onMessage(PacketTGKeybindPress message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTGKeybindPress message, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            TGExtendedPlayer props = TGExtendedPlayer.get(ply);
            if (message.buttonID == 0) {
                boolean bl = props.enableNightVision = !props.enableNightVision;
                if (!props.enableNightVision) {
                    if (ply.func_70660_b(MobEffects.field_76439_r) != null) {
                        ply.func_184589_d(MobEffects.field_76439_r);
                        ply.field_70170_p.func_184148_a(null, ply.field_70165_t, ply.field_70163_u + (double)ply.func_70047_e(), ply.field_70161_v, TGSounds.NIGHTVISION_OFF, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (GenericArmor.getArmorBonusForPlayer(ply, TGArmorBonus.NIGHTVISION, false) > 0.0f) {
                    ply.field_70170_p.func_184148_a(null, ply.field_70165_t, ply.field_70163_u + (double)ply.func_70047_e(), ply.field_70161_v, TGSounds.NIGHTVISION_ON, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                if (message.showMsg) {
                    TGPackets.network.sendTo((IMessage)new PacketShowKeybindConfirmMessage(message.buttonID, props.enableNightVision), (EntityPlayerMP)ply);
                }
                TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(ply, props, true), (EntityPlayerMP)ply);
            } else if (message.buttonID == 1) {
                boolean bl = props.enableSafemode = !props.enableSafemode;
                if (!props.enableSafemode && !Techguns.instance.permissions.canUseUnsafeMode(ply)) {
                    props.enableSafemode = true;
                }
                if (message.showMsg) {
                    TGPackets.network.sendTo((IMessage)new PacketShowKeybindConfirmMessage(message.buttonID, props.enableSafemode), (EntityPlayerMP)ply);
                }
                TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(ply, props, true), (EntityPlayerMP)ply);
            } else if (message.buttonID == 7) {
                if (!props.isJumpkeyPressed()) {
                    props.enableJetpack = !props.enableJetpack;
                    TGPackets.network.sendTo((IMessage)new PacketTGPlayerFieldSync((EntityLivingBase)ply, 1, props.enableJetpack), (EntityPlayerMP)ply);
                    if (message.showMsg) {
                        TGPackets.network.sendTo((IMessage)new PacketShowKeybindConfirmMessage(message.buttonID, props.enableJetpack), (EntityPlayerMP)ply);
                    }
                    if (!props.enableJetpack && props.isJumpkeyPressed()) {
                        props.setJumpkeyPressed(false);
                        TGPackets.network.sendToDimension((IMessage)new PacketTGPlayerFieldSync((EntityLivingBase)ply, 0, false), ply.field_70170_p.field_73011_w.getDimension());
                    }
                }
            } else if (message.buttonID == 2) {
                props.setJumpkeyPressed(true);
                TGPackets.network.sendToDimension((IMessage)new PacketTGPlayerFieldSync((EntityLivingBase)ply, 0, true), ply.field_70170_p.field_73011_w.getDimension());
            } else if (message.buttonID == 3) {
                props.setJumpkeyPressed(false);
                TGPackets.network.sendToDimension((IMessage)new PacketTGPlayerFieldSync((EntityLivingBase)ply, 0, false), ply.field_70170_p.field_73011_w.getDimension());
            } else if (message.buttonID == 4) {
                props.isForwardKeyPressed = true;
            } else if (message.buttonID == 5) {
                props.isForwardKeyPressed = false;
            } else if (message.buttonID == 6) {
                ItemStack item = ply.func_184586_b(message.hand);
                if (!item.func_190926_b() && item.func_77973_b() instanceof GenericGun) {
                    GenericGun gun = (GenericGun)item.func_77973_b();
                    gun.tryForcedReload(item, ply.field_70170_p, ply, message.hand);
                }
            } else if (message.buttonID == 9) {
                props.showTGHudElements = !props.showTGHudElements;
                TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(ply, props, true), (EntityPlayerMP)ply);
            } else if (message.buttonID == 8) {
                boolean bl = props.enableStepAssist = !props.enableStepAssist;
                if (message.showMsg) {
                    TGPackets.network.sendTo((IMessage)new PacketShowKeybindConfirmMessage(message.buttonID, props.enableStepAssist), (EntityPlayerMP)ply);
                }
                TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(ply, props, true), (EntityPlayerMP)ply);
            }
        }
    }
}

