/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.api.guns.IGenericGun;

public class PacketShootGunTarget
implements IMessage {
    public boolean isZooming = false;
    public boolean offHand = false;
    public int entityId = -1;

    public void fromBytes(ByteBuf buf) {
        this.isZooming = buf.readBoolean();
        this.offHand = buf.readBoolean();
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isZooming);
        buf.writeBoolean(this.offHand);
        buf.writeInt(this.entityId);
    }

    public PacketShootGunTarget() {
    }

    public EnumHand getHand() {
        return this.offHand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    public PacketShootGunTarget(boolean isZooming, EnumHand hand, Entity target) {
        this.isZooming = isZooming;
        this.offHand = hand == EnumHand.OFF_HAND;
        this.entityId = target.func_145782_y();
    }

    public static class Handler
    implements IMessageHandler<PacketShootGunTarget, IMessage> {
        public IMessage onMessage(PacketShootGunTarget message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketShootGunTarget message, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            ItemStack stack = ply.func_184586_b(message.getHand());
            Entity target = ply.field_70170_p.func_73045_a(message.entityId);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IGenericGun) {
                ((IGenericGun)stack.func_77973_b()).shootGunPrimary(stack, ply.field_70170_p, ply, message.isZooming, message.getHand(), target);
            }
        }
    }
}

