/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.packets.HandlerTemplate;
import techguns.util.TextUtil;

public class PacketMultiBlockFormInvalidBlockMessage
implements IMessage {
    public static final int MSG_TYPE_ORE_DRILL_FRAME_ERROR = 2;
    public static final int MSG_TYPE_ORE_DRILL_SCAFFOLD_ERROR = 3;
    public static final int MSG_TYPE_ORE_DRILL_ENGINE_ERROR = 1;
    public static final int MSG_TYPE_ORE_DRILL_AIR_ERROR = 4;
    public static final int MSG_TYPE_ORE_DRILL_ROD_PLACEMENT_ERROR = 5;
    public static final int MSG_TYPE_ORE_DRILL_CONTROLLER_PLACEMENT_ERROR = 6;
    public static final int MSG_TYPE_ORE_DRILL_CONTROLLER_ALONE = 7;
    public static final int MSG_TYPE_MULTIBLOCK_ERROR = 8;
    public static final int MSG_TYPE_ROD_SIZE = 9;
    protected BlockPos pos;
    protected short type;

    public PacketMultiBlockFormInvalidBlockMessage(BlockPos pos, int type) {
        this.pos = pos;
        this.type = (short)type;
    }

    public PacketMultiBlockFormInvalidBlockMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.type = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeShort((int)this.type);
    }

    public static class Handler
    extends HandlerTemplate<PacketMultiBlockFormInvalidBlockMessage> {
        @Override
        protected void handle(PacketMultiBlockFormInvalidBlockMessage message, MessageContext ctx) {
            EntityPlayer player = TGPackets.getPlayerFromContext(ctx);
            BlockPos p = message.pos;
            switch (message.type) {
                case 1: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.multiblock.oredrill.invalid.engines")), true);
                    break;
                }
                case 2: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.multiblock.oredrill.invalid.frame")), true);
                    break;
                }
                case 3: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.multiblock.oredrill.invalid.scaffold")), true);
                    break;
                }
                case 4: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.multiblock.oredrill.invalid.air")), true);
                    break;
                }
                case 5: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.alreadyrod")), true);
                    break;
                }
                case 6: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.oredrill.controllernext")), true);
                    break;
                }
                case 7: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.oredrill.controlleralone")), true);
                    break;
                }
                case 8: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.multiblockinvalid")), true);
                    break;
                }
                case 9: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.oredrill.rodsize")), true);
                    break;
                }
                default: {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.multiblock.invalidblock") + ": " + p.func_177958_n() + ", " + p.func_177956_o() + ", " + p.func_177952_p()), false);
                }
            }
        }
    }
}

