/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.client.ClientProxy;
import techguns.client.ShooterValues;

public class GunFiredMessage
implements IMessage {
    protected int entityID;
    protected int time;
    protected byte attackType;
    protected boolean checkRecoil;
    protected boolean offhand;
    protected int muzzleflashtime;

    public GunFiredMessage() {
    }

    public GunFiredMessage(EntityLivingBase shooter, int firetime, int muzzleflashtime, int attackType, boolean checkRecoil, boolean offhand) {
        this.entityID = shooter.func_145782_y();
        this.time = firetime;
        this.muzzleflashtime = muzzleflashtime;
        this.attackType = (byte)attackType;
        this.checkRecoil = checkRecoil;
        this.offhand = offhand;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.time = buf.readInt();
        this.muzzleflashtime = buf.readInt();
        this.attackType = buf.readByte();
        this.checkRecoil = buf.readBoolean();
        this.offhand = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.time);
        buf.writeInt(this.muzzleflashtime);
        buf.writeByte((int)this.attackType);
        buf.writeBoolean(this.checkRecoil);
        buf.writeBoolean(this.offhand);
    }

    public static class Handler
    implements IMessageHandler<GunFiredMessage, IMessage> {
        public IMessage onMessage(GunFiredMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(GunFiredMessage message, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            EntityLivingBase shooter = (EntityLivingBase)ply.field_70170_p.func_73045_a(message.entityID);
            boolean offHand = message.offhand;
            if (shooter != null) {
                ClientProxy cp = ClientProxy.get();
                if (!message.checkRecoil || !ShooterValues.isStillRecoiling(shooter, message.offhand, message.attackType)) {
                    ShooterValues.setRecoiltime(shooter, message.offhand, System.currentTimeMillis() + (long)message.time, message.time, message.attackType);
                    ShooterValues.setMuzzleFlashTime(shooter, message.offhand, System.currentTimeMillis() + (long)message.muzzleflashtime, message.muzzleflashtime);
                }
            }
        }
    }
}

