/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns.ammo;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import techguns.items.guns.ammo.AmmoVariant;
import techguns.util.ItemUtil;

public class AmmoType {
    protected ItemStack[] emptyMag = new ItemStack[]{ItemStack.field_190927_a};
    protected ArrayList<AmmoVariant> variants = new ArrayList();
    protected HashMap<String, Integer> ammoVariantIDs = new HashMap();
    protected int bulletsPerMag = 0;

    public AmmoType(ItemStack ... ammo) {
        this.variants.add(new AmmoVariant(ammo, ammo));
        this.ammoVariantIDs.put("default", 0);
    }

    public AmmoType addVariant(String key, ItemStack ammo, ItemStack bullet) {
        return this.addVariant(key, new ItemStack[]{ammo}, new ItemStack[]{bullet});
    }

    public AmmoType addVariant(String key, ItemStack ... ammo) {
        return this.addVariant(key, ammo, ammo);
    }

    public int getIDforVariantKey(String key) {
        if (this.ammoVariantIDs.containsKey(key)) {
            return this.ammoVariantIDs.get(key);
        }
        return 0;
    }

    public AmmoType addVariant(String key, ItemStack[] ammo, ItemStack[] bullet) {
        this.variants.add(new AmmoVariant(key, ammo, bullet));
        this.ammoVariantIDs.put(key, this.variants.size() - 1);
        return this;
    }

    public ItemStack[] getAmmo(int variant) {
        return this.variants.get((int)variant).ammo;
    }

    public ItemStack[] getEmptyMag() {
        return this.emptyMag;
    }

    public ItemStack[] getBullet(int variant) {
        return this.variants.get((int)variant).bullet;
    }

    public AmmoType(ItemStack ammo, ItemStack emptyMag, ItemStack bullet, int bulletsPerMag) {
        this(new ItemStack[]{ammo}, new ItemStack[]{emptyMag}, new ItemStack[]{bullet}, bulletsPerMag);
    }

    public AmmoType(ItemStack[] ammo, ItemStack[] emptyMag, ItemStack[] bullet, int bulletsPerMag) {
        this.variants.add(new AmmoVariant(ammo, bullet));
        this.emptyMag = emptyMag;
        this.bulletsPerMag = bulletsPerMag;
    }

    public String getAmmoVariantKeyfor(ItemStack stack, int index) {
        for (int i = 0; i < this.variants.size(); ++i) {
            if (!ItemUtil.isItemEqual(this.variants.get((int)i).ammo[index], stack)) continue;
            return this.variants.get((int)i).key;
        }
        return "default";
    }

    public ArrayList<AmmoVariant> getVariants() {
        return this.variants;
    }

    public boolean hasMultipleVariants() {
        return this.variants.size() > 1;
    }

    public float getShotsPerBullet(int clipsize, int ammoCount) {
        if (ammoCount == 1 && this.bulletsPerMag == 0) {
            return clipsize;
        }
        float bpm = this.bulletsPerMag == 0 ? (float)clipsize / (float)ammoCount : (float)this.bulletsPerMag;
        return (float)clipsize / bpm;
    }

    public int getBulletsPerMag() {
        return this.bulletsPerMag;
    }
}

