/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.items.armors.ArmorPowerType;
import techguns.items.armors.EnumArmorStat;
import techguns.items.armors.GenericArmorMultiCamo;
import techguns.items.armors.TGArmorBonus;
import techguns.items.armors.TGArmorMaterial;
import techguns.util.InventoryUtil;
import techguns.util.TextUtil;

public class PoweredArmor
extends GenericArmorMultiCamo {
    protected ArmorPowerType powerType;
    protected ItemStack battery = ItemStack.field_190927_a;
    protected ItemStack battery_empty = ItemStack.field_190927_a;
    public int maxpower;
    protected float SpeedBonusUnpowered = 0.0f;
    protected float JumpBonusUnpowered = 0.0f;
    protected float FallDMGUnpowered = 0.0f;
    protected float FallFreeHeightUnpowered = 0.0f;
    protected float MiningSpeedBonusUnpowered = 0.0f;
    protected float WaterMiningBonusUnpowered = 0.0f;
    protected int armorValueUnpowered = 0;
    protected float GunAccuracyUnpowered = 0.0f;
    protected float extraHeartsUnpowered = 0.0f;
    protected float nightvisionUnpowered = 0.0f;
    protected float knockbackresistanceUnpowered = 0.0f;
    protected float stepassistUnpowerd = 0.0f;
    protected float oxygen_gearUnpowered = 0.0f;
    protected float water_electrolyzerUnpowered = 0.0f;
    protected float coolingsystemUnpowered = 0.0f;
    protected float waterspeedbonusUnpowered = 0.0f;

    public PoweredArmor(String unlocalizedName, TGArmorMaterial material, String[] textureNames, EntityEquipmentSlot type, ArmorPowerType powerType, int maxpower) {
        this("techguns", unlocalizedName, material, textureNames, type, powerType, maxpower);
    }

    public PoweredArmor(String modid, String unlocalizedName, TGArmorMaterial material, String[] textureNames, EntityEquipmentSlot type, ArmorPowerType powerType, int maxpower) {
        super(modid, unlocalizedName, material, textureNames, type);
        this.powerType = powerType;
        this.maxpower = maxpower;
    }

    public PoweredArmor setBattery(ItemStack battery) {
        this.battery = battery;
        return this;
    }

    public PoweredArmor setEmptyBattery(ItemStack emptyBattery) {
        this.battery_empty = emptyBattery;
        return this;
    }

    public ItemStack getBattery() {
        return this.battery;
    }

    public ItemStack getBattery_empty() {
        return this.battery_empty;
    }

    public float getBonusUnpowered(TGArmorBonus type) {
        switch (type) {
            case SPEED: {
                return this.SpeedBonusUnpowered;
            }
            case JUMP: {
                return this.JumpBonusUnpowered;
            }
            case FALLDMG: {
                return this.FallDMGUnpowered;
            }
            case FREEHEIGHT: {
                return this.FallFreeHeightUnpowered;
            }
            case BREAKSPEED: {
                return this.MiningSpeedBonusUnpowered;
            }
            case BREAKSPEED_WATER: {
                return this.WaterMiningBonusUnpowered;
            }
            case GUN_ACCURACY: {
                return this.GunAccuracyUnpowered;
            }
            case EXTRA_HEART: {
                return this.extraHeartsUnpowered;
            }
            case NIGHTVISION: {
                return this.nightvisionUnpowered;
            }
            case KNOCKBACK_RESISTANCE: {
                return this.knockbackresistanceUnpowered;
            }
            case STEPASSIST: {
                return this.stepassistUnpowerd;
            }
            case OXYGEN_GEAR: {
                return this.oxygen_gearUnpowered;
            }
            case WATER_ELECTROLYZER: {
                return this.water_electrolyzerUnpowered;
            }
            case COOLING_SYSTEM: {
                return this.coolingsystemUnpowered;
            }
            case SPEED_WATER: {
                return this.waterspeedbonusUnpowered;
            }
        }
        return 0.0f;
    }

    public PoweredArmor setSpeedBoni(float speed, float jump, float speed_unpowered, float jump_unpowered) {
        this.SpeedBonus = speed;
        this.JumpBonus = jump;
        this.SpeedBonusUnpowered = speed_unpowered;
        this.JumpBonusUnpowered = jump_unpowered;
        return this;
    }

    public PoweredArmor setFallProtection(float multiplier, float freeheight, float multiplier_unpowered, float freeheight_unpowered) {
        this.FallDMG = multiplier;
        this.FallFreeHeight = freeheight;
        this.FallDMGUnpowered = multiplier_unpowered;
        this.FallFreeHeightUnpowered = freeheight_unpowered;
        return this;
    }

    public PoweredArmor setMiningBoni(float bonus, float bonus_unpowered) {
        this.MiningSpeedBonus = bonus;
        this.MiningSpeedBonusUnpowered = bonus_unpowered;
        return this;
    }

    public PoweredArmor setMiningBoniWater(float bonus, float bonus_unpowered) {
        this.WaterMiningBonus = bonus;
        this.WaterMiningBonusUnpowered = bonus_unpowered;
        return this;
    }

    public PoweredArmor setGunBonus(float acc, float acc_unpowered) {
        this.GunAccuracy = acc;
        this.GunAccuracyUnpowered = acc_unpowered;
        return this;
    }

    public PoweredArmor setHealthBonus(int bonusHearts, int bonusHeartsUnpowered) {
        this.extraHearts = bonusHearts;
        this.extraHeartsUnpowered = bonusHeartsUnpowered;
        return this;
    }

    public PoweredArmor setKnockbackResistance(float resistpercent, float resistpercent_unpowered) {
        this.knockbackresistance = resistpercent;
        this.knockbackresistanceUnpowered = resistpercent_unpowered;
        return this;
    }

    public PoweredArmor setStepAssist(float stepassist, float stepassist_unpowered) {
        this.stepassist = stepassist;
        this.stepassistUnpowerd = stepassist_unpowered;
        return this;
    }

    public PoweredArmor setOxygenGear(float value, float unpowered_value) {
        this.oxygen_gear = value;
        this.oxygen_gearUnpowered = unpowered_value;
        return this;
    }

    public PoweredArmor setCoolingSystem(float value, float unpowered_value) {
        this.coolingsystem = value;
        this.coolingsystemUnpowered = unpowered_value;
        return this;
    }

    public PoweredArmor setWaterspeedBonus(float value, float unpowered_value) {
        this.waterspeedbonus = value;
        this.waterspeedbonusUnpowered = unpowered_value;
        return this;
    }

    public static void consumePower(ItemStack armor, int amount) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
            tags.func_74768_a("maxpower", ((PoweredArmor)armor.func_77973_b()).maxpower);
        }
        int power = tags.func_74762_e("power");
        if ((power -= amount) < 0) {
            power = 0;
        }
        tags.func_74768_a("power", power);
    }

    public int setPowered(ItemStack armor, int max) {
        int power;
        int missing;
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
        }
        if ((missing = this.maxpower - (power = tags.func_74762_e("power"))) > max) {
            tags.func_74768_a("power", power + max);
            return max;
        }
        tags.func_74768_a("power", this.maxpower);
        return missing;
    }

    protected void setFullyPowered(ItemStack armor) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
            tags.func_74768_a("maxpower", ((PoweredArmor)armor.func_77973_b()).maxpower);
        }
        tags.func_74768_a("power", this.maxpower);
    }

    protected static boolean hasPower(ItemStack armor) {
        return PoweredArmor.getPower(armor) > 0;
    }

    public static int getPower(ItemStack armor) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
        }
        return tags.func_74762_e("power");
    }

    protected static void powerSlots(EntityPlayer player, ArmorPowerType power, ItemStack chest, boolean consumeTick) {
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (armor == null || !(armor.func_77973_b() instanceof PoweredArmor)) continue;
            if (i != 2) {
                if (((PoweredArmor)armor.func_77973_b()).powerType == power) {
                    int max = PoweredArmor.getPower(chest);
                    int dmg = ((PoweredArmor)armor.func_77973_b()).setPowered(armor, max);
                    PoweredArmor.consumePower(chest, dmg);
                }
                if (!consumeTick) continue;
                PoweredArmor.consumePower(armor, 1);
                continue;
            }
            if (!consumeTick) continue;
            PoweredArmor.consumePower(armor, 1);
        }
    }

    public int applyPowerConsumptionOnAction(TGArmorBonus type, EntityPlayer player) {
        if (type == TGArmorBonus.JUMP) {
            if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGSounds.STEAM_JUMP, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                return 5;
            }
        } else if (type == TGArmorBonus.FALLDMG) {
            if (this.field_77881_a == EntityEquipmentSlot.FEET) {
                return 5;
            }
        } else if (type == TGArmorBonus.COOLING_SYSTEM && this.field_77881_a == EntityEquipmentSlot.CHEST) {
            return 1;
        }
        return 0;
    }

    public static void calculateConsumptionTick(EntityPlayer player) {
        int modTick;
        boolean moving = false;
        float f = 0.001f;
        if (player.field_70159_w > (double)f || player.field_70179_y > (double)f || player.field_70159_w < (double)(-f) || player.field_70179_y < (double)(-f)) {
            moving = true;
        }
        ArmorPowerType power = null;
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (!chest.func_190926_b() && chest.func_77973_b() instanceof PoweredArmor) {
            power = ((PoweredArmor)chest.func_77973_b()).powerType;
        }
        PoweredArmor.powerSlots(player, power, chest, (modTick = (int)(player.field_70170_p.func_82737_E() % 20L)) == 0 && moving);
        if (!chest.func_190926_b() && chest.func_77973_b() instanceof PoweredArmor) {
            PoweredArmor powerChest = (PoweredArmor)chest.func_77973_b();
            if (!PoweredArmor.hasPower(chest) && InventoryUtil.consumeAmmoPlayer(player, powerChest.battery)) {
                int amount;
                if (powerChest.battery_empty != null && (amount = InventoryUtil.addAmmoToPlayerInventory(player, TGItems.newStack(powerChest.battery_empty, 1))) > 0 && !player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(powerChest.battery_empty, amount)));
                }
                powerChest.setFullyPowered(chest);
                PoweredArmor.powerSlots(player, power, chest, false);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack item, World worldIn, List<String> list, ITooltipFlag flagIn) {
        NBTTagCompound tags = item.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            item.func_77982_d(tags);
            tags.func_74768_a("power", 0);
        }
        int power = tags.func_74762_e("power");
        list.add(ChatFormatting.AQUA + TextUtil.transTG("tooltip.power") + ": " + power + "/" + this.maxpower);
        if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
            list.add(ChatFormatting.AQUA + TextUtil.transTG("tooltip.powerType") + ": " + this.powerType.toString() + " (" + TextUtil.trans(this.battery.func_77977_a() + ".name") + ")");
        } else {
            list.add(ChatFormatting.AQUA + TextUtil.transTG("tooltip.powerType") + ": " + this.powerType.toString());
        }
        super.func_77624_a(item, worldIn, list, flagIn);
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
        }
        tags.func_74768_a("power", 0);
    }

    public boolean setArmorStat(EnumArmorStat stat, float powered, float unpowered) {
        super.setArmorStat(stat, powered);
        switch (stat) {
            case COOLING_SYSTEM: {
                this.coolingsystemUnpowered = unpowered;
                return true;
            }
            case EXTRA_HEARTS: {
                this.extraHeartsUnpowered = unpowered;
                return true;
            }
            case FALL_DAMAGE: {
                this.FallDMGUnpowered = unpowered;
                return true;
            }
            case FALL_HEIGHT: {
                this.FallFreeHeightUnpowered = unpowered;
                return true;
            }
            case GUN_ACCURACY: {
                this.GunAccuracyUnpowered = unpowered;
                return true;
            }
            case JUMP: {
                this.JumpBonusUnpowered = unpowered;
                return true;
            }
            case KNOCKBACK_RESITANCE: {
                this.knockbackresistanceUnpowered = unpowered;
                return true;
            }
            case MINING_SPEED: {
                this.MiningSpeedBonusUnpowered = unpowered;
                return true;
            }
            case NIGHTVISION: {
                this.nightvisionUnpowered = unpowered;
                return true;
            }
            case OXYGEN_GEAR: {
                this.oxygen_gearUnpowered = unpowered;
                return true;
            }
            case SPEED: {
                this.SpeedBonusUnpowered = unpowered;
                return true;
            }
            case STEP_ASSIST: {
                this.stepassistUnpowerd = unpowered;
                return true;
            }
            case WATER_ELECTROLYZER: {
                this.water_electrolyzerUnpowered = unpowered;
                return true;
            }
            case WATER_MINING_SPEED: {
                this.WaterMiningBonusUnpowered = unpowered;
                return true;
            }
            case WATER_SPEED: {
                this.waterspeedbonusUnpowered = unpowered;
                return true;
            }
        }
        return false;
    }
}

