/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import techguns.TGArmors;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.ShieldStats;
import techguns.items.armors.ICamoChangeable;
import techguns.util.ItemStackOreDict;
import techguns.util.TextUtil;

public class GenericShield
extends ItemShield
implements ICamoChangeable {
    protected int camocount = 1;
    protected ItemStackOreDict repairMat = ItemStackOreDict.EMPTY;
    protected int repairMatCount = 0;
    protected static DecimalFormat formatReduction = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public GenericShield(String modid, String name, int durability, boolean addToList, int camocount) {
        this.func_77625_d(1);
        this.func_77637_a(Techguns.tabTechgun);
        this.setRegistryName(name);
        this.func_77655_b(modid + "." + name);
        this.camocount = Math.max(camocount, 1);
        this.func_77656_e(durability);
        if (addToList) {
            TGArmors.shields.add(this);
        }
    }

    public GenericShield(String modid, String name, int durability, boolean addToList) {
        this(modid, name, durability, addToList, 1);
    }

    public GenericShield(String name, int durability) {
        this("techguns", name, durability, true, 1);
    }

    public GenericShield(String name, int durability, int camocount) {
        this("techguns", name, durability, true, camocount);
    }

    public GenericShield setRepairMat(ItemStackOreDict mats, int amount) {
        this.repairMat = mats;
        this.repairMatCount = amount;
        return this;
    }

    public GenericShield setRepairMat(ItemStackOreDict mats) {
        this.repairMat = mats;
        this.repairMatCount = mats.stackSize;
        return this;
    }

    public ArrayList<ItemStack> getRepairMats(ItemStack item) {
        ArrayList<ItemStack> mats = new ArrayList<ItemStack>();
        if (item.func_77952_i() > 0) {
            GenericShield armor = (GenericShield)item.func_77973_b();
            float dmgpercent = (float)item.func_77952_i() * 1.0f / ((float)(item.func_77958_k() - 1) * 1.0f);
            int count = (int)Math.ceil((float)armor.repairMatCount * dmgpercent);
            if (!armor.repairMat.isEmpty() && count > 0) {
                mats.add(armor.repairMat.getItemStacks(count).get(0));
            }
        }
        return mats;
    }

    public boolean canRepairOnRepairBench(ItemStack item) {
        GenericShield shield = (GenericShield)item.func_77973_b();
        return shield.repairMatCount > 0;
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("minecraft:shield"), "inventory"));
    }

    @Override
    public int getCamoCount() {
        return this.camocount;
    }

    public boolean isShield(ItemStack stack, EntityLivingBase entity) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID > 0) {
            return TextUtil.trans(this.func_77658_a() + ".camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.defaultcamo");
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.repairMat.isEqualWithOreDict(repair) ? true : super.func_82789_a(toRepair, repair);
    }

    public void func_77624_a(ItemStack item, World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(item, worldIn, list, flagIn);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(this.trans("armorTooltip.durability") + ": " + (item.func_77958_k() - item.func_77952_i()) + "/" + item.func_77958_k());
            ShieldStats s = ShieldStats.getStats(item, null);
            list.add(ChatFormatting.BLUE + this.trans("armorTooltip.resistances") + ":");
            list.add(ChatFormatting.DARK_GRAY + " AR: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.PHYSICAL)) + "%");
            list.add(ChatFormatting.GRAY + " PR: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.PROJECTILE)) + "%");
            list.add(ChatFormatting.DARK_RED + " EX: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.EXPLOSION)) + "%");
            list.add(ChatFormatting.DARK_AQUA + " E: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.ENERGY)) + "%");
            list.add(ChatFormatting.RED + " F: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.FIRE)) + "%");
            list.add(ChatFormatting.AQUA + " I: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.ICE)) + "%");
            list.add(ChatFormatting.YELLOW + " L: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.LIGHTNING)) + "%");
            list.add(ChatFormatting.DARK_GREEN + " P: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.POISON)) + "%");
            list.add(ChatFormatting.DARK_GRAY + " D: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.DARK)) + "%");
            list.add(ChatFormatting.GREEN + " RAD: " + formatReduction.format(s.getReductionPercentAgainstType(DamageType.RADIATION)) + "%");
        } else {
            list.add(TextUtil.trans("techguns.gun.tooltip.shift1") + " " + ChatFormatting.GREEN + TextUtil.trans("techguns.gun.tooltip.shift2") + " " + ChatFormatting.GRAY + TextUtil.trans("techguns.gun.tooltip.shift3"));
        }
    }

    protected String trans(String text) {
        return TextUtil.trans("techguns." + text);
    }
}

