/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.ICamoChangeable;
import techguns.items.armors.TGArmorMaterial;
import techguns.util.TextUtil;

public class GenericArmorMultiCamo
extends GenericArmor
implements ICamoChangeable {
    protected static Random rnd = new Random();
    protected String[] textureNames;
    protected String camoNameSuffix = "";

    public GenericArmorMultiCamo(String unlocalizedName, TGArmorMaterial material, String[] textureNames, EntityEquipmentSlot type) {
        this("techguns", unlocalizedName, material, textureNames, type);
    }

    public GenericArmorMultiCamo(String modid, String unlocalizedName, TGArmorMaterial material, String[] textureNames, EntityEquipmentSlot type) {
        super(modid, unlocalizedName, material, textureNames[0], type);
        this.textureNames = textureNames;
    }

    public GenericArmorMultiCamo setCamoNameSuffix(String s) {
        this.camoNameSuffix = s + ".";
        return this;
    }

    @Override
    public void func_77624_a(ItemStack item, World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(item, worldIn, list, flagIn);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextUtil.trans("techguns.tooltip.currentcamo") + ": " + this.getCurrentCamoName(item));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        if (player.func_70093_af()) {
            ItemStack item = player.func_184586_b(handIn);
            this.switchCamo(item);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextUtil.trans("techguns.message.camoswitch") + " " + this.getCurrentCamoName(item)));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        return super.func_77659_a(world, player, handIn);
    }

    @Override
    public int getCamoCount() {
        if (this.textureNames != null) {
            return this.textureNames.length;
        }
        return 0;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = -1;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID >= 0) {
            return TextUtil.trans(this.modid + ".item." + this.textureNames[0] + "." + this.camoNameSuffix + "camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.invalidcamo");
    }

    public static int getRandomCamoIndexFor(GenericArmorMultiCamo type) {
        int count = type.getCamoCount();
        if (count <= 0) {
            return 0;
        }
        return rnd.nextInt(count);
    }

    public static ItemStack getNewWithCamo(Item item, int camo) {
        ItemStack armor = new ItemStack(item);
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
        }
        tags.func_74774_a("camo", (byte)camo);
        return armor;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
        }
        tags.func_74774_a("camo", (byte)0);
    }

    protected static int getArmorLayer(EntityEquipmentSlot slot) {
        return EntityEquipmentSlot.LEGS == slot ? 2 : 1;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        GenericArmorMultiCamo armor = (GenericArmorMultiCamo)stack.func_77973_b();
        int i = armor.getCurrentCamoIndex(stack);
        if (i >= 0 && i < this.textureNames.length) {
            return this.modid + ":textures/models/armor/" + this.textureNames[i] + (this.hasDoubleTexture() ? "_layer_" + GenericArmorMultiCamo.getArmorLayer(slot) : "") + ".png";
        }
        return null;
    }
}

