/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.additionalslots;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;
import techguns.capabilities.TGExtendedPlayer;
import techguns.items.GenericItem;
import techguns.items.armors.ICamoChangeable;
import techguns.util.TextUtil;

public abstract class ItemTGSpecialSlot
extends GenericItem
implements ITGSpecialSlot,
ICamoChangeable {
    protected ResourceLocation texture;
    protected byte camoCount;
    protected TGSlotType slot;

    public ItemTGSpecialSlot(String unlocalizedName, TGSlotType slot, int camoCount, int dur) {
        super(unlocalizedName);
        this.field_77777_bU = 1;
        this.func_77656_e(dur);
        this.camoCount = (byte)camoCount;
        this.slot = slot;
    }

    @Override
    public int getCamoCount() {
        return this.camoCount;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID > 0) {
            return TextUtil.trans(this.func_77658_a() + ".camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.defaultcamo");
    }

    @Override
    public TGSlotType getSlot(ItemStack item) {
        return this.slot;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(ChatFormatting.GRAY + TextUtil.trans("techguns.tooltip.slot") + ": " + (Object)((Object)this.getSlot(stack)));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (this.getSlot(stack) == TGSlotType.BACKSLOT) {
            TGExtendedPlayer props = TGExtendedPlayer.get(playerIn);
            if (((ItemStack)props.tg_inventory.inventory.get(1)).func_190926_b()) {
                props.tg_inventory.inventory.set(1, (Object)stack.func_77946_l());
                stack.func_190920_e(0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (this.getSlot(stack) == TGSlotType.FACESLOT) {
            TGExtendedPlayer props = TGExtendedPlayer.get(playerIn);
            if (((ItemStack)props.tg_inventory.inventory.get(0)).func_190926_b()) {
                props.tg_inventory.inventory.set(0, (Object)stack.func_77946_l());
                stack.func_190920_e(0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (this.getSlot(stack) == TGSlotType.HANDSLOT) {
            TGExtendedPlayer props = TGExtendedPlayer.get(playerIn);
            if (((ItemStack)props.tg_inventory.inventory.get(2)).func_190926_b()) {
                props.tg_inventory.inventory.set(2, (Object)stack.func_77946_l());
                stack.func_190920_e(0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

