/*
 * Decompiled with CFR 0.152.
 */
package techguns.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import techguns.TGItems;
import techguns.api.render.IItemTGRenderer;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;
import techguns.items.GenericItem;
import techguns.items.armors.TGArmorBonus;
import techguns.tileentities.operation.UpgradeBenchRecipes;
import techguns.util.InventoryUtil;
import techguns.util.TextUtil;

public class GenericItemShared
extends GenericItem
implements IItemTGRenderer,
ITGSpecialSlot {
    protected ArrayList<SharedItemEntry> sharedItems = new ArrayList();

    public GenericItemShared() {
        super("itemshared", false);
    }

    public ItemStack addsharedVariant(String name) {
        return this.addsharedVariant(name, false);
    }

    public ItemStack addsharedVariant(String name, boolean useRenderHack) {
        return this.addsharedVariant(name, useRenderHack, TGSlotType.NORMAL);
    }

    public ItemStack addsharedVariant(String name, TGSlotType slottype) {
        return this.addsharedVariant(name, false, slottype);
    }

    public ItemStack addsharedVariant(String name, boolean useRenderHack, TGSlotType slottype) {
        return this.addsharedVariant(name, useRenderHack, slottype, 64, true);
    }

    public ItemStack addsharedVariantOptional(String name, boolean enabled) {
        return this.addsharedVariant(name, false, TGSlotType.NORMAL, 64, enabled);
    }

    public ItemStack addsharedVariant(String name, boolean useRenderHack, TGSlotType slottype, int maxStackSize, boolean enabled) {
        int newMeta = this.sharedItems.size();
        this.sharedItems.add(new SharedItemEntry(name, newMeta, slottype, (short)maxStackSize, useRenderHack, enabled));
        return new ItemStack((Item)this, 1, newMeta);
    }

    public int getItemStackLimit(ItemStack stack) {
        int dmg = stack.func_77952_i();
        if (dmg < this.sharedItems.size()) {
            return this.sharedItems.get((int)dmg).maxStackSize;
        }
        return super.getItemStackLimit(stack);
    }

    public SharedItemEntry get(int damageValue) {
        return this.sharedItems.get(damageValue);
    }

    @Override
    public void initModel() {
        for (int i = 0; i < this.sharedItems.size(); ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("techguns", this.sharedItems.get((int)i).name), "inventory"));
        }
    }

    public ArrayList<SharedItemEntry> getSharedItems() {
        return this.sharedItems;
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.sharedItems.size(); ++i) {
                if (!this.sharedItems.get(i).isEnabled()) continue;
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.techguns." + this.getSharedItems().get((int)stack.func_77952_i()).name;
    }

    @Override
    public boolean shouldUseRenderHack(ItemStack stack) {
        return this.getSharedItems().get((int)stack.func_77952_i()).useRenderHack;
    }

    @Override
    public TGSlotType getSlot(ItemStack item) {
        int dmg = item.func_77952_i();
        if (dmg < this.sharedItems.size()) {
            return this.sharedItems.get((int)dmg).slottype;
        }
        return TGSlotType.NORMAL;
    }

    protected SharedItemEntry getSharedEntry(ItemStack item) {
        int dmg = item.func_77952_i();
        if (dmg < this.sharedItems.size()) {
            return this.sharedItems.get(dmg);
        }
        return null;
    }

    @Override
    public float getBonus(TGArmorBonus type, ItemStack stack, boolean consume, EntityPlayer player) {
        if (stack.func_77952_i() == TGItems.OXYGEN_MASK.func_77952_i()) {
            if (type == TGArmorBonus.OXYGEN_GEAR) {
                return 1.0f;
            }
        } else if (stack.func_77952_i() == TGItems.WORKING_GLOVES.func_77952_i() && type == TGArmorBonus.BREAKSPEED) {
            return 0.1f;
        }
        return 0.0f;
    }

    private float getBonus(TGArmorBonus type, ItemStack stack) {
        return this.getBonus(type, stack, false, null);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.getSlot(stack) != TGSlotType.NORMAL) {
            tooltip.add(ChatFormatting.GRAY + TextUtil.trans("techguns.tooltip.slot") + ": " + (Object)((Object)this.getSlot(stack)));
            if (this.getSlot(stack) == TGSlotType.AMMOSLOT) {
                tooltip.add(ChatFormatting.GRAY + TextUtil.trans("techguns.tooltip.rightclickammoslot"));
                if (this.getSharedEntry((ItemStack)stack).ammoEntry != null) {
                    tooltip.add(ChatFormatting.GRAY + TextUtil.trans("techguns.tooltip.sneakrightclickunload"));
                }
            } else if (this.getSlot(stack) == TGSlotType.ARMOR_UPGRADE) {
                this.addArmorEnchantTooltip(stack, worldIn, tooltip, flagIn);
            }
        }
        if (this.getBonus(TGArmorBonus.EXTRA_HEART, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.healthbonus") + ": +" + (int)this.getBonus(TGArmorBonus.EXTRA_HEART, stack) + " " + this.trans("armorTooltip.hearts"));
        } else if (this.getBonus(TGArmorBonus.SPEED, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.movespeed") + ": +" + this.getBonus(TGArmorBonus.SPEED, stack) * 100.0f + "%");
        } else if (this.getBonus(TGArmorBonus.JUMP, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.jumpheight") + ": +" + this.getBonus(TGArmorBonus.JUMP, stack));
        }
        if (this.getBonus(TGArmorBonus.FALLDMG, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.falldamage") + ": -" + this.getBonus(TGArmorBonus.FALLDMG, stack) * 100.0f + "%");
        }
        if (this.getBonus(TGArmorBonus.FREEHEIGHT, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.fallheight") + ": -" + this.getBonus(TGArmorBonus.FREEHEIGHT, stack));
        }
        if (this.getBonus(TGArmorBonus.BREAKSPEED, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.miningspeed") + ": +" + this.getBonus(TGArmorBonus.BREAKSPEED, stack) * 100.0f + "%");
        }
        if (this.getBonus(TGArmorBonus.BREAKSPEED_WATER, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.underwatermining") + ": +" + this.getBonus(TGArmorBonus.BREAKSPEED_WATER, stack) * 100.0f + "%");
        }
        if (this.getBonus(TGArmorBonus.KNOCKBACK_RESISTANCE, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.knockbackresistance") + ": +" + this.getBonus(TGArmorBonus.KNOCKBACK_RESISTANCE, stack) * 100.0f + "%");
        }
        if (this.getBonus(TGArmorBonus.NIGHTVISION, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.nightvision"));
        }
        if (this.getBonus(TGArmorBonus.STEPASSIST, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.stepassist"));
        }
        if (this.getBonus(TGArmorBonus.OXYGEN_GEAR, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.oxygengear"));
        }
        if (this.getBonus(TGArmorBonus.COOLING_SYSTEM, stack) > 0.0f) {
            tooltip.add(this.trans("armorTooltip.coolingsystem"));
        }
        if (stack.func_77952_i() == TGItems.OREDRILLHEAD_STEEL.func_77952_i() || stack.func_77952_i() == TGItems.OREDRILLHEAD_MEDIUM_STEEL.func_77952_i() || stack.func_77952_i() == TGItems.OREDRILLHEAD_LARGE_STEEL.func_77952_i()) {
            tooltip.add(this.trans("oredrill.mininglevel") + " +1");
        } else if (stack.func_77952_i() == TGItems.OREDRILLHEAD_OBSIDIANSTEEL.func_77952_i() || stack.func_77952_i() == TGItems.OREDRILLHEAD_MEDIUM_OBSIDIANSTEEL.func_77952_i() || stack.func_77952_i() == TGItems.OREDRILLHEAD_LARGE_OBSIDIANSTEEL.func_77952_i()) {
            tooltip.add(this.trans("oredrill.mininglevel") + " +2");
        } else if (stack.func_77952_i() == TGItems.OREDRILLHEAD_CARBON.func_77952_i() || stack.func_77952_i() == TGItems.OREDRILLHEAD_MEDIUM_CARBON.func_77952_i() || stack.func_77952_i() == TGItems.OREDRILLHEAD_LARGE_CARBON.func_77952_i()) {
            tooltip.add(this.trans("oredrill.mininglevel") + " +3");
        }
    }

    protected void addArmorEnchantTooltip(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        UpgradeBenchRecipes.UpgradeBenchRecipe rec = UpgradeBenchRecipes.getUpgradeRecipeForUpgradeItem(stack);
        if (rec != null) {
            Enchantment ench = rec.getEnch();
            tooltip.add(TextFormatting.AQUA + ench.func_77316_c(rec.getLevel()));
            if (flagIn.func_194127_a() && ench.field_77351_y != null) {
                tooltip.add(" " + ench.field_77351_y.toString());
            }
        }
    }

    private String trans(String text) {
        return TextUtil.trans("techguns." + text);
    }

    protected static void addAmmoToPlayerOrDropInWorld(EntityPlayer player, ItemStack stack) {
        int amount = InventoryUtil.addAmmoToPlayerInventory(player, stack);
        if (amount > 0 && !player.field_70170_p.field_72995_K) {
            ItemStack stackDrop = stack.func_77946_l();
            stackDrop.func_190920_e(amount);
            InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stackDrop);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            SharedItemAmmoEntry ammoEntry;
            SharedItemEntry entry = this.getSharedEntry(stack);
            if (entry != null && (ammoEntry = entry.getAmmoEntry()) != null) {
                ItemStack stackBullet = ammoEntry.bullet.func_77946_l();
                stackBullet.func_190920_e(ammoEntry.amountBullet);
                ItemStack stackMag = ammoEntry.magazine.func_77946_l();
                stackMag.func_190920_e(ammoEntry.amountMag);
                GenericItemShared.addAmmoToPlayerOrDropInWorld(player, stackBullet);
                GenericItemShared.addAmmoToPlayerOrDropInWorld(player, stackMag);
                stack.func_190918_g(1);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (this.getSlot(stack) == TGSlotType.AMMOSLOT) {
            ItemStack newStack = stack.func_77946_l();
            int amount = InventoryUtil.addAmmoToAmmoInventory(player, newStack);
            System.out.println("amount not merged:" + amount);
            stack.func_190920_e(amount);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public static class SharedItemAmmoEntry {
        public ItemStack bullet;
        public ItemStack magazine;
        public int amountBullet;
        public int amountMag;

        public SharedItemAmmoEntry(ItemStack bullet, ItemStack magazine, int amountBullet, int amountMag) {
            this.bullet = bullet;
            this.magazine = magazine;
            this.amountBullet = amountBullet;
            this.amountMag = amountMag;
        }

        public SharedItemAmmoEntry(ItemStack bullet, ItemStack magazine, int amountBullet) {
            this(bullet, magazine, amountBullet, 1);
        }
    }

    public static class SharedItemEntry {
        protected String name;
        protected TGSlotType slottype;
        protected short maxStackSize;
        protected int meta;
        protected boolean useRenderHack;
        protected boolean enabled;
        protected SharedItemAmmoEntry ammoEntry;

        public SharedItemEntry(String name, int meta, TGSlotType slottype, short maxStackSize, boolean useRenderHack, boolean enabled) {
            this.name = name;
            this.slottype = slottype;
            this.maxStackSize = maxStackSize;
            this.meta = meta;
            this.useRenderHack = useRenderHack;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public TGSlotType getSlottype() {
            return this.slottype;
        }

        public short getMaxStackSize() {
            return this.maxStackSize;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public SharedItemAmmoEntry getAmmoEntry() {
            return this.ammoEntry;
        }

        public void setAmmoType(ItemStack bullet, ItemStack magazine, int amountBullet) {
            this.ammoEntry = new SharedItemAmmoEntry(bullet, magazine, amountBullet);
        }
    }
}

