/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.spawn;

import java.util.ArrayList;
import techguns.entities.spawn.TGNpcSpawn;
import techguns.util.MathUtil;

public class TGNpcSpawnTable {
    protected final int maxDanger;
    protected final ArrayList<ArrayList<TGNpcSpawn>> spawnlist;

    public TGNpcSpawnTable() {
        this(5);
    }

    public TGNpcSpawnTable(int maxDanger) {
        this.maxDanger = maxDanger;
        this.spawnlist = new ArrayList();
        for (int i = 0; i <= maxDanger; ++i) {
            this.spawnlist.add(new ArrayList());
        }
    }

    public ArrayList<TGNpcSpawn> get(int dangerlevel) {
        dangerlevel = MathUtil.clamp(dangerlevel, 0, this.maxDanger);
        return this.spawnlist.get(dangerlevel);
    }

    public void registerSpawn(TGNpcSpawn spawn, int danger) {
        if (spawn.spawnWeight <= 0) {
            return;
        }
        if (danger < 0 || danger > this.maxDanger) {
            System.out.println("Tried to register NPC spawn for dangerlevel outside of [0-" + this.maxDanger + "]: " + danger);
            return;
        }
        ArrayList<TGNpcSpawn> list = this.spawnlist.get(danger);
        list.add(spawn);
    }
}

