/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IChargedProjectileFactory;
import techguns.packets.PacketSpawnParticle;

public class PowerHammerProjectile
extends GenericProjectile {
    public PowerHammerProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    public PowerHammerProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    public PowerHammerProjectile(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        if (!this.field_70170_p.field_72995_K) {
            double x = rayTraceResult.field_72307_f.field_72450_a;
            double y = rayTraceResult.field_72307_f.field_72448_b;
            double z = rayTraceResult.field_72307_f.field_72449_c;
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.POWERHAMMER_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("PowerhammerImpact", x, y, z), TGPackets.targetPointAroundEnt(this, 32.0));
        }
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        if (!this.field_70170_p.field_72995_K) {
            double x = rayTraceResult.field_72307_f.field_72450_a;
            double y = rayTraceResult.field_72307_f.field_72448_b;
            double z = rayTraceResult.field_72307_f.field_72449_c;
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.POWERHAMMER_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("PowerhammerImpact", x, y, z), TGPackets.targetPointAroundEnt(this, 32.0));
        }
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = new TGDamageSource("powerhammer", this, (Entity)this.shooter, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        src.goreChance = 1.0f;
        src.armorPenetration = this.penetration;
        return src;
    }

    public static class Factory
    implements IChargedProjectileFactory<PowerHammerProjectile> {
        @Override
        public PowerHammerProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new PowerHammerProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.PHYSICAL;
        }

        @Override
        public PowerHammerProjectile createChargedProjectile(World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity, float charge, int ammoConsumed) {
            return new PowerHammerProjectile(world, p, damage * (float)ammoConsumed, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin * (float)ammoConsumed, penetration, blockdamage, firePos);
        }
    }
}

