/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.TGRadiationSystem;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.AbstractBeamProjectile;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;

public class NDRProjectile
extends AbstractBeamProjectile {
    public static final int BEAM_LIFETIME = 10;
    public int shooterID;

    public NDRProjectile(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            Techguns.proxy.createFXOnEntity("BeamGunMuzzleFX", this);
        }
    }

    public NDRProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        if (this.shooter != null) {
            buffer.writeInt(this.shooter.func_145782_y());
        } else {
            buffer.writeInt(0);
        }
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.shooterID = additionalData.readInt();
    }

    @Override
    public void func_70071_h_() {
        Entity e;
        double targetX = 0.0;
        double targetY = 0.0;
        double targetZ = 0.0;
        float f = 100.0f;
        if (this.shooter == null && (e = this.field_70170_p.func_73045_a(this.shooterID)) instanceof EntityLivingBase) {
            this.shooter = (EntityLivingBase)e;
        }
        if (this.shooter != null) {
            double dx = -MathHelper.func_76126_a((float)(this.shooter.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            double dz = MathHelper.func_76134_b((float)(this.shooter.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            double dy = -MathHelper.func_76126_a((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            this.field_70165_t = this.shooter.field_70165_t;
            this.field_70163_u = this.shooter.field_70163_u;
            this.field_70161_v = this.shooter.field_70161_v;
            Vec3d motion = new Vec3d(dx, dy, dz).func_72432_b();
            this.field_70159_w = motion.field_72450_a * (double)this.speed;
            this.field_70181_x = motion.field_72448_b * (double)this.speed;
            this.field_70179_y = motion.field_72449_c * (double)this.speed;
            if (Techguns.proxy.isClientPlayerAndIn1stPerson(this.shooter)) {
                Vec3d offset = this.getFPOffset();
                offset = offset.func_178789_a((float)((double)this.shooter.field_70125_A * (Math.PI / 180))).func_178785_b((float)((-90.0 - (double)this.shooter.field_70759_as) * (Math.PI / 180)));
                this.field_70165_t += offset.field_72450_a;
                this.field_70163_u += offset.field_72448_b + (double)this.shooter.func_70047_e();
                this.field_70161_v += offset.field_72449_c;
            } else {
                this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
                this.field_70163_u += (double)this.shooter.func_70047_e() - (double)0.1f + (double)this.get3PYOffset();
                this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            }
            Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70125_A = this.shooter.field_70125_A;
            this.field_70177_z = this.shooter.field_70759_as;
        }
        this.trace();
        --this.ticksToLive;
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        Vec3d hitVec = rayTraceResult.field_72307_f;
        Techguns.proxy.createFX("BeamGunImpactFX", this.field_70170_p, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, 0.0, 0.0, 0.0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public Vec3d getFPOffset() {
        return new Vec3d(0.0, -0.08, 0.12);
    }

    public float get3PYOffset() {
        return 0.0f;
    }

    public float getBeam3PYOffset() {
        return 0.0f;
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResultIn) {
        super.onHitEffect(ent, rayTraceResultIn);
        if (TGRadiationSystem.isEnabled()) {
            ent.func_70690_d(new PotionEffect((Potion)TGRadiationSystem.radiation_effect, 40, 4, false, true));
        }
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeRadiationDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    public static class Factory
    implements IProjectileFactory<NDRProjectile> {
        @Override
        public NDRProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new NDRProjectile(world, p, damage, speed, 10, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.RADIATION;
        }
    }
}

