/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npcs;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npcs.GenericNPC;
import techguns.items.armors.GenericArmor;

public abstract class GenericNPCGearSpecificStats
extends GenericNPC {
    public GenericNPCGearSpecificStats(World world) {
        super(world);
    }

    @Override
    public float getTotalArmorAgainstType(TGDamageSource dmgsrc) {
        Iterable inv = this.func_184193_aE();
        float totalArmor = 0.0f;
        for (ItemStack stack : inv) {
            float armorvalue;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            if (stack.func_77973_b() instanceof GenericArmor) {
                GenericArmor genArmor = (GenericArmor)stack.func_77973_b();
                armorvalue = genArmor.getArmorValue(stack, dmgsrc.field_76373_n);
                totalArmor += armorvalue;
                continue;
            }
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            armorvalue = armor.func_82812_d().func_78044_b(armor.field_77881_a);
            armorvalue = DamageSystem.getArmorAgainstDamageTypeDefault((EntityLivingBase)this, armorvalue, dmgsrc.field_76373_n);
            totalArmor += armorvalue;
        }
        return totalArmor;
    }

    @Override
    public float getPenetrationResistance(TGDamageSource dmgsrc) {
        Iterable inv = this.func_184193_aE();
        float res = 0.0f;
        for (ItemStack stack : inv) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof GenericArmor)) continue;
            GenericArmor genArmor = (GenericArmor)stack.func_77973_b();
            float antipen = genArmor.getPenetrationResistance();
            res += antipen;
        }
        return res;
    }

    @Override
    public float getToughnessAfterPentration(EntityLivingBase elb, TGDamageSource src) {
        Iterable inv = this.func_184193_aE();
        float t = 0.0f;
        for (ItemStack stack : inv) {
            float dt;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof GenericArmor) {
                GenericArmor genArmor = (GenericArmor)stack.func_77973_b();
                dt = genArmor.field_189415_e - Math.max(src.armorPenetration - genArmor.getPenetrationResistance(), 0.0f);
                t += Math.max(dt, 0.0f);
                continue;
            }
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            ItemArmor a = (ItemArmor)stack.func_77973_b();
            dt = a.field_189415_e - src.armorPenetration;
            t += Math.max(dt, 0.0f);
        }
        return t;
    }
}

