/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npcs;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npcs.GenericFlyingMob;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.entities.projectiles.RocketProjectile;
import techguns.packets.PacketPlaySound;

public class AttackHelicopter
extends GenericFlyingMob {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(AttackHelicopter.class, (DataSerializer)DataSerializers.field_187198_h);
    private int ambientSoundTick = 0;
    protected static final int TARGET_FLY_HEIGHT = 24;
    public static final int MAX_DEATH_TIME = 100;
    protected static final ResourceLocation LOOT = new ResourceLocation("techguns", "entities/attackhelicopter");
    protected boolean tryLink = true;

    public AttackHelicopter(World worldIn) {
        super(worldIn);
        this.func_70105_a(4.0f, 4.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new GenericFlyingMob.FlyingMobMoveHelper(this);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new GenericFlyingMob.AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new GenericFlyingMob.AILookAround(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIHelicopterAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(5.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TGSounds.HELICOPTER_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return TGSounds.HELICOPTER_HIT;
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (--this.ambientSoundTick <= 0 && this.field_70725_aQ == 0) {
            this.func_184185_a(TGSounds.HELICOPTER_ROTOR, 6.0f, 1.0f);
            this.ambientSoundTick = 61;
        }
    }

    public float func_70047_e() {
        return 0.5f;
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 0) {
            this.func_184185_a(TGSounds.HELICOPTER_DEATH, 6.0f, 1.0f);
        }
        ++this.field_70725_aQ;
        float yoffset = (float)(Math.pow((float)this.field_70725_aQ / 100.0f, 2.0) * 10.0);
        if (this.field_70725_aQ % 5 == 0) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d = this.field_70146_Z.nextGaussian() * 0.02;
        }
        if (this.field_70725_aQ % 6 == 0) {
            float v = 1.0f;
            float angle = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            float x = (float)Math.cos(angle);
            float z = (float)Math.sin(angle);
            float f = 0.5f + this.field_70146_Z.nextFloat() * 0.5f;
        }
        if (this.field_70725_aQ == 100) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.func_184185_a(TGSounds.HELICOPTER_EXPLODE, 6.0f, 1.0f);
            Techguns.proxy.createFX("HelicopterDeathExplosion", this.field_70170_p, this.field_70165_t, this.field_70163_u - 8.0, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getTotalArmorAgainstType(TGDamageSource dmgsrc) {
        switch (dmgsrc.field_76373_n) {
            case EXPLOSION: {
                return 0.0f;
            }
            case LIGHTNING: 
            case ENERGY: {
                return 10.0f;
            }
            case FIRE: 
            case ICE: 
            case PHYSICAL: 
            case PROJECTILE: 
            case POISON: 
            case RADIATION: {
                return 20.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getPenetrationResistance(TGDamageSource dmgsrc) {
        switch (dmgsrc.field_76373_n) {
            case PROJECTILE: {
                return 0.5f;
            }
            case EXPLOSION: 
            case LIGHTNING: 
            case ENERGY: 
            case FIRE: 
            case ICE: 
            case PHYSICAL: 
            case POISON: 
            case RADIATION: 
            case UNRESISTABLE: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getWeaponPosX() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosY() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosZ() {
        return 0.0f;
    }

    @Override
    public float getBulletOffsetSide() {
        return 2.0f;
    }

    @Override
    protected int getTargetFlyHeight() {
        return 24;
    }

    static class AIHelicopterAttack
    extends EntityAIBase {
        private final AttackHelicopter parentEntity;
        public int attackTimer;

        public AIHelicopterAttack(AttackHelicopter heli) {
            this.parentEntity = heli;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer >= 14 && this.attackTimer < 24 && this.attackTimer % 2 == 0) {
                    if (this.attackTimer == 14) {
                        TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.HELICOPTER_BURST, (Entity)this.parentEntity, 8.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE), TGPackets.targetPointAroundEnt((Entity)this.parentEntity, 100.0));
                    }
                    GenericProjectile bullet = new GenericProjectile(this.parentEntity.field_70170_p, (EntityLivingBase)this.parentEntity, 12.0f, 1.0f, 100, 0.05f, 30.0f, 40.0f, 8.0f, 0.25f, false, EnumBulletFirePos.CENTER);
                    world.func_72838_d((Entity)bullet);
                } else if (this.attackTimer == 35) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.ROCKET_FIRE, (Entity)this.parentEntity, 8.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE), TGPackets.targetPointAroundEnt((Entity)this.parentEntity, 100.0));
                    RocketProjectile rocket = new RocketProjectile(this.parentEntity.field_70170_p, (EntityLivingBase)this.parentEntity, 12.0f, 1.0f, 100, 0.05f, 30.0f, 40.0f, 8.0f, 0.25f, false, this.parentEntity.field_70146_Z.nextBoolean() ? EnumBulletFirePos.LEFT : EnumBulletFirePos.RIGHT, 4.0f, 0.0);
                    world.func_72838_d((Entity)rocket);
                } else if (this.attackTimer > 35) {
                    this.attackTimer = -30;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }
    }
}

