/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.tileentities;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import techguns.client.render.TGRenderHelper;
import techguns.tileentities.DungeonScannerTileEnt;
import techguns.world.dungeon.TemplateSegment;

public class RenderDungeonScanner
extends TileEntitySpecialRenderer<DungeonScannerTileEnt> {
    public static final ResourceLocation GHOST_TEXTURE = new ResourceLocation("techguns", "textures/entity/white.png");

    public void render(DungeonScannerTileEnt te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te == null || !te.showGhost) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        int spacing = 1;
        for (TemplateSegment.SegmentType type : TemplateSegment.templateSegments.keySet()) {
            GlStateManager.func_179094_E();
            TemplateSegment temp = TemplateSegment.templateSegments.get((Object)type);
            GlStateManager.func_179109_b((float)(spacing + (te.sizeXZ + spacing) * temp.col), (float)0.0f, (float)(spacing + (te.sizeXZ + spacing) * temp.row));
            TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
            GlStateManager.func_179129_p();
            this.drawGhost(type, te.sizeXZ, te.sizeY);
            GlStateManager.func_179089_o();
            TGRenderHelper.disableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void drawGhost(TemplateSegment.SegmentType type, int sizeXZ, int sizeY) {
        float offset = 0.05f;
        this.drawGhostBox(offset, offset, offset, (float)sizeXZ - 2.0f * offset, 1.0 - (double)(2.0f * offset), (float)sizeXZ - 2.0f * offset, 1.0f, 0.5f, 0.5f, 0.25f);
        if (type != TemplateSegment.SegmentType.RAMP && type != TemplateSegment.SegmentType.FOUNDATION && type != TemplateSegment.SegmentType.PILLARS) {
            this.drawGhostBox(offset, offset + (float)sizeY - 1.0f, offset, (float)sizeXZ - 2.0f * offset, 1.0 - (double)(2.0f * offset), (float)sizeXZ - 2.0f * offset, 0.5f, 1.0f, 0.5f, 0.25f);
        }
        switch (type) {
            case STRAIGHT: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + (float)sizeXZ - 1.0f, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case CURVE: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset + (float)sizeXZ - 1.0f, offset + 1.0f, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case FORK: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset + (float)sizeXZ - 1.0f, offset + 1.0f, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case CROSS: {
                this.drawGhostBox(offset, offset + 1.0f, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset + (float)sizeXZ - 1.0f, offset + 1.0f, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset + (float)sizeXZ - 1.0f, offset + 1.0f, offset, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case END: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + (float)sizeXZ - 1.0f, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 2.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case RAMP: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY * 2 - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + (float)sizeXZ - 1.0f, (float)sizeXZ - 2.0f * offset, (float)(sizeY * 2 - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox((float)sizeXZ - offset - 1.0f, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 1) - offset * 2.0f, (float)sizeXZ - 2.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + (float)sizeY - 1.0f, offset + 1.0f, 1.0 - (double)(2.0f * offset), 1.0 - (double)(2.0f * offset), (float)(sizeXZ - 2) - 2.0f * offset, 0.5f, 1.0f, 0.5f, 0.25f);
                this.drawGhostBox((float)(sizeXZ - 1) + offset, offset + (float)sizeY, offset + 1.0f, 1.0 - (double)(2.0f * offset), 1.0 - (double)(2.0f * offset), (float)(sizeXZ - 2) - 2.0f * offset, 1.0f, 0.5f, 0.5f, 0.125f);
                this.drawGhostBox(offset, offset + (float)(sizeY * 2) - 1.0f, offset, (float)sizeXZ - 2.0f * offset, 1.0 - (double)(2.0f * offset), (float)sizeXZ - 2.0f * offset, 0.5f, 1.0f, 0.5f, 0.25f);
                this.drawGhostBox(offset, (float)sizeY + offset, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 1) - offset * 2.0f, (float)sizeXZ - 2.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                float f = (float)sizeXZ / ((float)sizeY + 1.0f);
                for (int i = 1; i < sizeY; ++i) {
                    this.drawGhostBox(offset + f * (float)i, offset + (float)i, (float)sizeXZ * 0.5f - 0.5f, 1.0f - 2.0f * offset, 1.0f - 2.0f * offset, 1.0f - 2.0f * offset, 0.5f, 1.0f, 1.0f, 0.25f);
                }
                break;
            }
            case ENTRANCE: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + (float)sizeXZ - 1.0f, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 2.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(-offset, 1.0, (double)sizeXZ * 0.5 - 0.5 - (double)offset, 1.0f + 2.0f * offset, 2.0f + offset, 1.0f + 2.0f * offset, 1.0f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case ROOM_WALL: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case ROOM_CORNER: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case ROOM_INNER: {
                break;
            }
            case ROOM_DOOR: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox((double)sizeXZ * 0.5 - 0.5 - (double)offset, 1.0, -offset, 1.0f + 2.0f * offset, 2.0f + offset, 1.0f + 2.0f * offset, 1.0f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case ROOM_DOOR_CORNER1: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox((double)sizeXZ * 0.5 - 0.5 - (double)offset, 1.0, -offset, 1.0f + 2.0f * offset, 2.0f + offset, 1.0f + 2.0f * offset, 1.0f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case ROOM_DOOR_CORNER2: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(-offset, 1.0, (double)sizeXZ * 0.5 - 0.5 - (double)offset, 1.0f + 2.0f * offset, 2.0f + offset, 1.0f + 2.0f * offset, 1.0f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case ROOM_DOOR_CORNER_DOUBLE: {
                this.drawGhostBox(offset, offset + 1.0f, offset, (float)sizeXZ - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset + 1.0f, offset + 1.0f, 1.0f - 2.0f * offset, (float)(sizeY - 2) - offset * 2.0f, (float)sizeXZ - 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox((double)sizeXZ * 0.5 - 0.5 - (double)offset, 1.0, -offset, 1.0f + 2.0f * offset, 2.0f + offset, 1.0f + 2.0f * offset, 1.0f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(-offset, 1.0, (double)sizeXZ * 0.5 - 0.5 - (double)offset, 1.0f + 2.0f * offset, 2.0f + offset, 1.0f + 2.0f * offset, 1.0f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case FOUNDATION: {
                this.drawGhostBox(offset, offset, offset, (float)sizeXZ - 2.0f * offset, (float)sizeY - offset * 2.0f, (float)sizeXZ - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                break;
            }
            case PILLARS: {
                this.drawGhostBox(offset, offset, offset, 1.0f - 2.0f * offset, (float)sizeY - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset + (float)sizeXZ - 1.0f, offset, offset, 1.0f - 2.0f * offset, (float)sizeY - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset + (float)sizeXZ - 1.0f, offset, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)sizeY - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
                this.drawGhostBox(offset, offset, offset + (float)sizeXZ - 1.0f, 1.0f - 2.0f * offset, (float)sizeY - offset * 2.0f, 1.0f - 2.0f * offset, 0.5f, 0.5f, 1.0f, 0.25f);
            }
        }
    }

    protected void drawGhostBox(double x, double y, double z, double sizeX, double sizeY, double sizeZ, float r, float g, float b, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GHOST_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        this.drawGhostBoxPlane(buffer, x, y, z, sizeX, sizeY, 0.0, r, g, b, alpha);
        this.drawGhostBoxPlane(buffer, x, y, z, 0.0, sizeY, sizeZ, r, g, b, alpha);
        this.drawGhostBoxPlane(buffer, x + sizeX, y, z + sizeZ, -sizeX, sizeY, 0.0, r, g, b, alpha);
        this.drawGhostBoxPlane(buffer, x + sizeX, y, z + sizeZ, 0.0, sizeY, -sizeZ, r, g, b, alpha);
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x, y, z + sizeZ).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + sizeX, y, z + sizeZ).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + sizeX, y, z).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x, y + sizeY, z).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x, y + sizeY, z + sizeZ).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + sizeX, y + sizeY, z + sizeZ).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + sizeX, y + sizeY, z).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawGhostBoxPlane(BufferBuilder buffer, double x, double y, double z, double w_x, double h, double w_z, float r, float g, float b, float alpha) {
        buffer.func_181662_b(x + 0.0, y + h, z + w_z).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + w_x, y + h, z).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + w_x, y + 0.0, z).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, z + w_z).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
    }
}

