/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.projectiles;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import techguns.client.render.TGRenderHelper;
import techguns.deatheffects.EntityDeathUtils;
import techguns.util.MathUtil;

public class DeathEffectEntityRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ResourceLocation RES_BIO_EFFECT = new ResourceLocation("techguns", "textures/fx/bio.png");
    private static final ResourceLocation RES_LASER_EFFECT = new ResourceLocation("techguns", "textures/fx/laserdeath.png");
    private static final int MAX_DEATH_TIME = 20;
    public static Field RLB_mainModel = ReflectionHelper.findField(RenderLivingBase.class, (String)"mainModel", (String)"field_77045_g");
    protected static Method RLB_preRenderCallback = ReflectionHelper.findMethod(RenderLivingBase.class, (String)"preRenderCallback", (String)"func_77041_b", (Class[])new Class[]{EntityLivingBase.class, Float.TYPE});
    protected static Method R_bindEntityTexture = ReflectionHelper.findMethod(Render.class, (String)"bindEntityTexture", (String)"func_180548_c", (Class[])new Class[]{Entity.class});
    public static Field R_renderManager = ReflectionHelper.findField(Render.class, (String)"renderManager", (String)"field_76990_c");
    protected static Method R_bindTexture = ReflectionHelper.findMethod(Render.class, (String)"bindTexture", (String)"func_110776_a", (Class[])new Class[]{ResourceLocation.class});
    protected static Method RLB_getColorMultiplier = ReflectionHelper.findMethod(RenderLivingBase.class, (String)"getColorMultiplier", (String)"func_77030_a", (Class[])new Class[]{EntityLivingBase.class, Float.TYPE, Float.TYPE});

    public static void preRenderCallback(RenderLivingBase<? extends EntityLivingBase> renderer, EntityLivingBase elb, float ptt) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RLB_preRenderCallback.invoke(renderer, elb, Float.valueOf(ptt));
    }

    public static void bindEntityTexture(Render<? extends Entity> renderer, Entity entity) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        R_bindEntityTexture.invoke(renderer, entity);
    }

    public static void setRenderScalingForEntity(EntityLivingBase elb) {
        if (elb instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)elb;
            int size = slime.func_70809_q();
            GlStateManager.func_179152_a((float)size, (float)size, (float)size);
            if (size == 2) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.8f, (float)0.0f);
            } else if (size == 4) {
                GlStateManager.func_179109_b((float)0.0f, (float)-1.2f, (float)0.0f);
            }
        }
    }

    public static void doRender(RenderLivingBase renderer, EntityLivingBase entity, double x, double y, double z, float ptt, EntityDeathUtils.DeathType deathType) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        ModelBase mainModel = null;
        try {
            mainModel = (ModelBase)RLB_mainModel.get(renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mainModel.field_78091_s = entity.func_70631_g_();
        try {
            float f2 = MathUtil.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, ptt);
            float f3 = MathUtil.interpolateRotation(entity.field_70758_at, entity.field_70759_as, ptt);
            float f13 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * ptt;
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            float f4 = (float)entity.field_70173_aa + ptt;
            float f5 = 0.0625f;
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-24.0f * f5 - 0.0078125f), (float)0.0f);
            float f6 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * ptt;
            float f7 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - ptt);
            if (entity.func_70631_g_()) {
                f7 *= 3.0f;
            }
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            GlStateManager.func_179141_d();
            switch (deathType) {
                case BIO: {
                    mainModel.func_78086_a(entity, f7, f6, ptt);
                    DeathEffectEntityRenderer.preRenderCallback((RenderLivingBase<? extends EntityLivingBase>)renderer, entity, ptt);
                    DeathEffectEntityRenderer.renderModelDeathBio(renderer, entity, f7, f6, f4, f3 - f2, f13, f5);
                    break;
                }
                case LASER: {
                    mainModel.func_78086_a(entity, f7, f6, ptt);
                    DeathEffectEntityRenderer.preRenderCallback((RenderLivingBase<? extends EntityLivingBase>)renderer, entity, ptt);
                    DeathEffectEntityRenderer.renderModelDeathLaser(renderer, entity, f7, f6, f4, f3 - f2, f13, f5);
                    break;
                }
            }
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    static void renderModelDeathBio(RenderLivingBase renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5) {
        ModelRenderer box;
        float prog = (float)entity.field_70725_aQ / 20.0f;
        Random rand = new Random(entity.func_145782_y());
        ResourceLocation texture = RES_BIO_EFFECT;
        TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)RLB_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            R_bindEntityTexture.invoke((Object)renderer, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mainModel instanceof ModelBiped) {
            ((ModelBiped)mainModel).func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
        }
        HashSet childBoxes = new HashSet(64);
        for (Object o : mainModel.field_78092_r) {
            box = (ModelRenderer)o;
            if (box.field_78805_m == null) continue;
            childBoxes.addAll(box.field_78805_m);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)entity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
        DeathEffectEntityRenderer.setRenderScalingForEntity(entity);
        for (Object o : mainModel.field_78092_r) {
            box = (ModelRenderer)o;
            if (childBoxes.contains(box) || box.field_78807_k || !box.field_78806_j) continue;
            float scale = 1.0f + rand.nextFloat() * prog;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-box.field_82906_o), (float)(-box.field_82908_p), (float)(-box.field_82907_q));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179109_b((float)box.field_82906_o, (float)box.field_82908_p, (float)box.field_82907_q);
            double mainColor = 1.0 - Math.pow(prog, 2.0);
            double mainAlpha = Math.pow(1.0 - (double)prog, 2.0);
            GlStateManager.func_179131_c((float)((float)mainColor), (float)1.0f, (float)((float)mainColor), (float)((float)mainAlpha));
            box.func_78785_a(f5);
            renderManager.field_78724_e.func_110577_a(RES_BIO_EFFECT);
            TGRenderHelper.enableBlendMode(renderType);
            double overlayColor = 0.5 + Math.sin((Math.sqrt(prog) + 0.75) * 2.0 * Math.PI) / 2.0;
            GlStateManager.func_179124_c((float)((float)overlayColor), (float)((float)overlayColor), (float)((float)overlayColor));
            box.func_78785_a(f5);
            TGRenderHelper.disableBlendMode(renderType);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    static void renderModelDeathLaser(RenderLivingBase renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5) {
        float prog = (float)entity.field_70725_aQ / 20.0f;
        Random rand = new Random(entity.func_145782_y());
        TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)RLB_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            R_bindEntityTexture.invoke((Object)renderer, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mainModel instanceof ModelBiped) {
            ((ModelBiped)mainModel).func_78087_a(f7, f6, f4, p_77036_5_, f13, f5, (Entity)entity);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)entity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
        DeathEffectEntityRenderer.setRenderScalingForEntity(entity);
        double mainColor = 1.0 - Math.pow(prog, 2.0);
        double mainAlpha = Math.pow(1.0 - (double)prog, 2.0);
        GlStateManager.func_179131_c((float)1.0f, (float)((float)mainColor), (float)((float)mainColor), (float)((float)mainAlpha));
        mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
        renderManager.field_78724_e.func_110577_a(RES_LASER_EFFECT);
        TGRenderHelper.enableBlendMode(renderType);
        double overlayColor = 0.5 + Math.sin((Math.sqrt(prog) + 0.75) * 2.0 * Math.PI) / 2.0;
        GlStateManager.func_179124_c((float)((float)overlayColor), (float)((float)overlayColor), (float)((float)overlayColor));
        mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
        TGRenderHelper.disableBlendMode(renderType);
        GlStateManager.func_179121_F();
    }

    static void GLTransformDeath_Body(float prog, EntityLivingBase entity, double xdir, double ydir, double zdir) {
        double p = Math.min(1.0, (double)prog * 2.0);
        double y = Math.sin(p * Math.PI);
        double y2 = (1.0 - Math.cos(p * Math.PI)) * 0.5;
        GlStateManager.func_179137_b((double)0.0, (double)((double)entity.field_70131_O * 0.75), (double)0.0);
        GlStateManager.func_179114_b((float)(-90.0f * (float)y2), (float)((float)xdir), (float)((float)ydir), (float)((float)zdir));
        GlStateManager.func_179137_b((double)0.0, (double)((double)(-entity.field_70131_O) * 0.75), (double)0.0);
        GlStateManager.func_179137_b((double)0.0, (double)(0.25 * y), (double)0.0);
    }

    static void GLTransformDeath_Head(float prog, EntityLivingBase entity, Random rand, ModelRenderer head) {
        double p = Math.min(1.0, (double)prog * 2.0);
        double a = Math.sin(p * Math.PI);
        double a2 = (1.0 - Math.cos(p * Math.PI)) * 0.5;
        double x1 = -1.0;
        double x2 = -1.0;
        double y1 = -1.0;
        double y2 = -1.0;
        double z1 = -1.0;
        double z2 = -1.0;
        for (Object b : head.field_78804_l) {
            ModelBox box = (ModelBox)b;
            if (x1 == -1.0 || (double)box.field_78252_a < x1) {
                x1 = box.field_78252_a;
            }
            if (x2 == -1.0 || (double)box.field_78248_d > x2) {
                x2 = box.field_78248_d;
            }
            if (y1 == -1.0 || (double)box.field_78250_b < y1) {
                y1 = box.field_78250_b;
            }
            if (y2 == -1.0 || (double)box.field_78249_e > y2) {
                y2 = box.field_78249_e;
            }
            if (z1 == -1.0 || (double)box.field_78251_c < z1) {
                z1 = box.field_78251_c;
            }
            if (z2 != -1.0 && !((double)box.field_78246_f > z2)) continue;
            z2 = box.field_78246_f;
        }
        double d = 0.0625;
        double offsetX = (x1 + (x2 - x1) * 0.5) * d;
        double offsetY = (y1 + (y2 - y1) * 0.5) * d;
        double offsetZ = (z1 + (z2 - z1) * 0.5) * d;
        GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
        GlStateManager.func_179114_b((float)(360.0f * prog), (float)rand.nextFloat(), (float)rand.nextFloat(), (float)rand.nextFloat());
        GlStateManager.func_179137_b((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
    }

    static void renderModel(RenderLivingBase renderer, EntityLivingBase entity, float f7, float f6, float f4, float p_77036_5_, float f13, float f5, ResourceLocation texture, TGRenderHelper.RenderType renderType) {
        ModelBase mainModel = null;
        RenderManager renderManager = null;
        try {
            mainModel = (ModelBase)RLB_mainModel.get(renderer);
            renderManager = (RenderManager)R_renderManager.get(renderer);
            if (texture != null) {
                renderManager.field_78724_e.func_110577_a(RES_BIO_EFFECT);
            } else {
                R_bindEntityTexture.invoke((Object)renderer, entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TGRenderHelper.enableBlendMode(renderType);
        if (!entity.func_82150_aj()) {
            mainModel.func_78088_a((Entity)entity, f7, f6, f4, p_77036_5_, f13, f5);
        }
        TGRenderHelper.disableBlendMode(renderType);
    }
}

