/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import techguns.TGConfig;
import techguns.client.particle.ITGParticle;
import techguns.client.particle.TGParticleSystem;
import techguns.client.particle.list.ParticleList;

public class TGParticleManager {
    public static double interpPosX;
    public static double interpPosY;
    public static double interpPosZ;
    protected ParticleList<TGParticleSystem> list_systems = new ParticleList();
    protected ParticleList<ITGParticle> list = new ParticleList();
    protected ParticleList<ITGParticle> list_nosort = new ParticleList();
    protected ComparatorParticleDepth compare = new ComparatorParticleDepth();

    public void addEffect(ITGParticle effect) {
        if (effect == null) {
            return;
        }
        if (effect instanceof TGParticleSystem) {
            this.list_systems.add((TGParticleSystem)effect);
        } else if (effect.doNotSort()) {
            this.list_nosort.add(effect);
        } else {
            this.list.add(effect);
        }
    }

    public void tickParticles() {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        Entity viewEnt = Minecraft.func_71410_x().func_175606_aa();
        Iterator sysit = this.list_systems.iterator();
        while (sysit.hasNext()) {
            TGParticleSystem p = (TGParticleSystem)sysit.next();
            p.updateTick();
            if (!p.shouldRemove()) continue;
            sysit.remove();
        }
        Iterator it = this.list.iterator();
        while (((ParticleList.ParticleListIterator)it).hasNext()) {
            ITGParticle p = (ITGParticle)((ParticleList.ParticleListIterator)it).next();
            p.updateTick();
            if (p.shouldRemove()) {
                ((ParticleList.ParticleListIterator)it).remove();
                continue;
            }
            if (viewEnt == null) continue;
            p.setDepth(this.distanceToPlane(viewEnt, p.getPos()));
        }
        Iterator it2 = this.list_nosort.iterator();
        while (it2.hasNext()) {
            ITGParticle p = (ITGParticle)it2.next();
            p.updateTick();
            if (!p.shouldRemove()) continue;
            it2.remove();
        }
        if (TGConfig.cl_sortPassesPerTick > 0) {
            this.doSorting();
        }
    }

    public void doSorting() {
        this.list.doBubbleSort(TGConfig.cl_sortPassesPerTick, this.compare);
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        float f1 = MathHelper.func_76134_b((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76126_a((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f3 = -f2 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f4 = f1 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76134_b((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        interpPosX = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        interpPosY = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        interpPosZ = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179129_p();
        this.list.forEach(p -> p.doRender(bufferbuilder, entityIn, partialTicks, f1, f5, f2, f3, f4));
        this.list_nosort.forEach(p -> p.doRender(bufferbuilder, entityIn, partialTicks, f1, f5, f2, f3, f4));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public double distanceToPlane(Entity viewEntity, Vec3d pos) {
        Vec3d n = viewEntity.func_70040_Z();
        double dot1 = -n.func_72430_b(pos.func_178788_d(viewEntity.func_174791_d()));
        double dot2 = n.func_72430_b(n);
        double f = dot1 / dot2;
        Vec3d pos2 = pos.func_178787_e(n.func_186678_a(f));
        return pos.func_72436_e(pos2);
    }

    public static class ComparatorParticleDepth
    implements Comparator<ITGParticle> {
        @Override
        public int compare(ITGParticle p1, ITGParticle p2) {
            double dist2;
            if (p1.doNotSort() && p2.doNotSort()) {
                return 0;
            }
            double dist1 = p1.getDepth();
            if (dist1 < (dist2 = p2.getDepth())) {
                return 1;
            }
            if (dist1 > dist2) {
                return -1;
            }
            return 0;
        }
    }
}

