/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import elucent.albedo.lighting.Light;
import net.minecraftforge.fml.common.Optional;
import techguns.client.ClientProxy;

public class LightPulse {
    private int ttl;
    protected int lifetime;
    protected int fade_in;
    protected double x;
    protected double y;
    protected double z;
    protected float rad_start;
    protected float rad_end;
    protected float r;
    protected float g;
    protected float b;

    public LightPulse(double x, double y, double z, int fade_in, int fade_out, float rad_large, float rad_small, float r, float g, float b) {
        this.ttl = this.lifetime = fade_in + fade_out;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rad_start = rad_large;
        this.rad_end = rad_small;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public LightPulse(double x, double y, double z, int lifetime, float rad_start, float rad_end, float r, float g, float b) {
        this.fade_in = 0;
        this.lifetime = lifetime;
        this.ttl = lifetime;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rad_start = rad_start;
        this.rad_end = rad_end;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public boolean updateGameTick() {
        --this.ttl;
        return this.ttl > 0;
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        float ptt = ClientProxy.get().PARTIAL_TICK_TIME;
        float existed = (float)(this.lifetime - this.ttl) + ptt;
        float prog = existed < (float)this.fade_in ? existed / (float)this.fade_in : (existed - (float)this.fade_in) / (float)(this.lifetime - this.fade_in);
        float inv_prog = 1.0f - prog;
        return Light.builder().pos(this.x, this.y, this.z).color(this.r, this.g, this.b).radius(this.rad_end * prog + this.rad_start * inv_prog).build();
    }
}

