/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.audio;

import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.client.audio.TGSoundCategory;
import techguns.util.EntityCondition;
import techguns.util.MathUtil;

@SideOnly(value=Side.CLIENT)
public class TGSound
extends MovingSound {
    Entity entity;
    boolean gunPosition;
    boolean moving;
    TGSoundCategory tgcategory = null;
    EntityCondition condition = EntityCondition.NONE;

    public TGSound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, TGSoundCategory category, EntityCondition condition) {
        this(soundname, entity, volume, pitch, repeat, moving, gunPosition, category);
        this.condition = condition;
    }

    public TGSound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, TGSoundCategory category) {
        this(soundname, entity, volume, pitch, repeat, moving, category);
        this.gunPosition = gunPosition;
        if (gunPosition && entity instanceof EntityLivingBase) {
            Vec2f pos = MathUtil.polarOffsetXZ(this.field_147660_d, this.field_147658_f, 1.0f, (float)((double)((EntityLivingBase)entity).field_70759_as * Math.PI / 180.0));
            this.field_147660_d = pos.field_189982_i;
            this.field_147658_f = pos.field_189983_j;
            this.field_147661_e += entity.field_70131_O * 0.5f;
        }
    }

    public TGSound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, TGSoundCategory category) {
        this(soundname, entity, volume, pitch, repeat, category);
        this.moving = moving;
        if (entity != null) {
            this.field_147660_d = (float)entity.field_70165_t;
            this.field_147661_e = (float)entity.field_70163_u;
            this.field_147658_f = (float)entity.field_70161_v;
        }
    }

    public TGSound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, TGSoundCategory category) {
        super(soundname, category.getVanillaCategory());
        this.tgcategory = category;
        this.field_147662_b = volume;
        this.field_147663_c = pitch;
        this.field_147659_g = repeat;
        this.entity = entity;
    }

    public TGSound(SoundEvent soundname, float posx, float posy, float posz, float volume, float pitch, boolean repeat, TGSoundCategory category) {
        this(soundname, null, volume, pitch, repeat, category);
        this.field_147660_d = posx;
        this.field_147661_e = posy;
        this.field_147658_f = posz;
    }

    public void setDonePlaying() {
        this.field_147659_g = false;
        this.field_147668_j = true;
        this.field_147665_h = 0;
    }

    public void func_73660_a() {
        if (this.entity != null && !this.condition.evaluate(this.entity)) {
            this.setDonePlaying();
        }
        if (this.moving && this.entity != null) {
            this.field_147660_d = (float)this.entity.field_70165_t;
            this.field_147661_e = (float)this.entity.field_70163_u;
            this.field_147658_f = (float)this.entity.field_70161_v;
            if (this.gunPosition && this.entity instanceof EntityLivingBase) {
                Vec2f pos = MathUtil.polarOffsetXZ(this.field_147660_d, this.field_147658_f, 1.0f, (float)((double)((EntityLivingBase)this.entity).field_70759_as * Math.PI / 180.0));
                this.field_147660_d = pos.field_189982_i;
                this.field_147658_f = pos.field_189983_j;
                this.field_147661_e += this.entity.field_70131_O * 0.5f;
            }
        } else if (this.moving) {
            this.setDonePlaying();
        }
    }

    public void setPitch(float pitch) {
        this.field_147663_c = pitch;
    }

    public void setRepeatDelay(int delay) {
        this.field_147665_h = delay;
    }
}

