/*
 * Decompiled with CFR 0.152.
 */
package techguns.client;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import techguns.api.capabilities.AttackTime;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.capabilities.TGExtendedPlayer;
import techguns.capabilities.TGShooterValues;
import techguns.client.ClientProxy;

public class ShooterValues {
    protected static AttackTime getAttackTimes(EntityLivingBase ent, boolean offHand) {
        TGShooterValues caps;
        if (ent instanceof EntityPlayer) {
            TGExtendedPlayer caps2 = TGExtendedPlayer.get((EntityPlayer)ent);
            if (caps2 != null) {
                return caps2.getAttackTime(offHand);
            }
        } else if (ent instanceof INPCTechgunsShooter && (caps = TGShooterValues.get(ent)) != null) {
            return caps.getAttackTime(offHand);
        }
        return null;
    }

    public static long getRecoiltime(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getRecoilTime();
        }
        return 0L;
    }

    public static boolean isStillRecoiling(EntityLivingBase ent, boolean offHand, byte attacktype) {
        if (ent != ClientProxy.get().getPlayerClient()) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            return false;
        }
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack == null) {
            return false;
        }
        if (attack.getAttackType() != attacktype) {
            return false;
        }
        if (attack.getRecoilTime() <= 0L) {
            return false;
        }
        boolean b = System.currentTimeMillis() - attack.getRecoilTime() < 0L;
        return b;
    }

    public static void setRecoiltime(EntityLivingBase ent, boolean offHand, long time, int total, byte attacktype) {
        ShooterValues.setRecoiltime(ent, offHand, time, total, attacktype, 0.0f);
    }

    public static void setRecoiltime(EntityLivingBase ent, boolean offHand, long time, int total, byte attacktype, float chargeProgress) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            attack.setRecoilTime(time);
            attack.setRecoilTimeTotal(total);
            attack.setAttackType(attacktype);
            attack.setRecoilChargeProgress(chargeProgress);
        }
    }

    public static long getRecoiltimeTotal(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getRecoilTimeTotal();
        }
        return 0L;
    }

    public static long getReloadtime(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getReloadTime();
        }
        return 0L;
    }

    public static byte getAttackType(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getAttackType();
        }
        return 0;
    }

    public static void setReloadtime(EntityLivingBase ent, boolean offHand, long time, int total, byte attackType) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            attack.setReloadTime(time);
            attack.setReloadTimeTotal(total);
            attack.setAttackType(attackType);
        }
    }

    public static int getReloadtimeTotal(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getReloadTimeTotal();
        }
        return 0;
    }

    public static boolean getIsCurrentlyUsingGun(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        return attack.isReloading() || attack.isRecoiling();
    }

    public static boolean getPlayerIsReloading(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        return attack.isReloading();
    }

    public static void setMuzzleFlashTime(EntityLivingBase ent, boolean offHand, long time, int total) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            attack.setMuzzleFlashTime(time);
            attack.setMuzzleFlashTimeTotal(total);
        }
    }

    public static long getMuzzleFlashTime(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getMuzzleFlashTime();
        }
        return 0L;
    }

    public static int getMuzzleFlashTimeTotal(EntityLivingBase ent, boolean offHand) {
        AttackTime attack = ShooterValues.getAttackTimes(ent, offHand);
        if (attack != null) {
            return attack.getMuzzleFlashTimeTotal();
        }
        return 0;
    }
}

