/*
 * Decompiled with CFR 0.152.
 */
package techguns.capabilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.api.capabilities.ITGExtendedPlayer;
import techguns.api.capabilities.ITGShooterValues;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.capabilities.TGDeathTypeCap;
import techguns.capabilities.TGDeathTypeCapProvider;
import techguns.capabilities.TGExtendedPlayer;
import techguns.capabilities.TGExtendedPlayerCapProvider;
import techguns.capabilities.TGExtendedPlayerClient;
import techguns.capabilities.TGShooterValues;
import techguns.capabilities.TGShooterValuesCapProvider;
import techguns.capabilities.TGSpawnerNPCData;
import techguns.capabilities.TGSpawnerNPCDataCapProvider;
import techguns.entities.npcs.ITGSpawnerNPC;

@Mod.EventBusSubscriber(modid="techguns")
public class CapabilityEventHandler {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object cap;
        if (event.getObject() instanceof INPCTechgunsShooter) {
            cap = new TGShooterValues();
            event.addCapability(TGShooterValuesCapProvider.ID, (ICapabilityProvider)new TGShooterValuesCapProvider((ITGShooterValues)cap));
        } else if (event.getObject() instanceof EntityPlayer) {
            cap = ((Entity)event.getObject()).field_70170_p.field_72995_K ? new TGExtendedPlayerClient((EntityPlayer)event.getObject()) : new TGExtendedPlayer((EntityPlayer)event.getObject());
            event.addCapability(TGExtendedPlayerCapProvider.ID, (ICapabilityProvider)new TGExtendedPlayerCapProvider((ITGExtendedPlayer)cap));
        }
        if (event.getObject() instanceof ITGSpawnerNPC) {
            cap = new TGSpawnerNPCData();
            event.addCapability(TGSpawnerNPCDataCapProvider.ID, (ICapabilityProvider)new TGSpawnerNPCDataCapProvider((TGSpawnerNPCData)cap));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void attachCapabilitiesClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            TGDeathTypeCap cap = new TGDeathTypeCap((EntityLivingBase)event.getObject());
            event.addCapability(TGDeathTypeCapProvider.ID, (ICapabilityProvider)new TGDeathTypeCapProvider(cap));
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        TGExtendedPlayer oldValues = TGExtendedPlayer.get(event.getOriginal());
        TGExtendedPlayer newValues = TGExtendedPlayer.get(event.getEntityPlayer());
        if (oldValues != null && newValues != null) {
            newValues.copyFrom(oldValues);
        }
    }
}

