/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines.multiblocks;

import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.BlockOreCluster;
import techguns.blocks.machines.BlockOreDrill;
import techguns.blocks.machines.EnumOreDrillType;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.blocks.machines.multiblocks.MultiBlockMachineSchematic;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.OreDrillTileEntMaster;

public class OreDrillDefinition
extends MultiBlockMachineSchematic {
    protected static final EnumFacing[][] DIRECTIONS_AROUND_AXIS = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.UP, EnumFacing.SOUTH}, {EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.UP, EnumFacing.WEST}};
    public static final int MAX_RADIUS = 3;
    public static final int MAX_SIZE = 16;

    public OreDrillDefinition() {
        super(OreDrillTileEntMaster.class);
    }

    @Override
    public boolean checkForm(World w, EntityPlayer player, BlockPos masterPos, EnumFacing direction) {
        int dir = this.getDirection(w, player, masterPos);
        if (dir < 0) {
            OreDrillDefinition.sendErrorMSG(w, masterPos, player, 7);
            return false;
        }
        EnumFacing drill_direction = EnumFacing.func_82600_a((int)dir);
        int[] length = this.checkLength(w, masterPos, drill_direction);
        int engines = length[0];
        int rods = length[1];
        if (engines >= 0 && rods > 0 && rods + engines <= 16) {
            if (engines == 0 && rods == 1) {
                return true;
            }
            int rad = this.checkWidth(w, masterPos, drill_direction);
            if (this.checkDrillSize(rods, engines, rad)) {
                if (OreDrillDefinition.allBlocksMatch(w, player, this.getEngineBlocks(w, masterPos, drill_direction, rad, engines), TGBlocks.ORE_DRILL_BLOCK.func_176223_P().func_177226_a((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.ENGINE)).func_177226_a((IProperty)BlockOreDrill.FORMED, (Comparable)Boolean.valueOf(false)), false)) {
                    if (OreDrillDefinition.allBlocksMatch(w, player, this.getFrameBlocks(w, masterPos, drill_direction, rad + 1, engines + rods, true, true), TGBlocks.ORE_DRILL_BLOCK.func_176223_P().func_177226_a((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.FRAME)).func_177226_a((IProperty)BlockOreDrill.FORMED, (Comparable)Boolean.valueOf(false)), false)) {
                        if (OreDrillDefinition.allBlocksMatch(w, player, this.getFrameBlocks(w, masterPos, drill_direction, rad + 1, engines + rods, false, true), TGBlocks.ORE_DRILL_BLOCK.func_176223_P().func_177226_a((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.SCAFFOLD)).func_177226_a((IProperty)BlockOreDrill.FORMED, (Comparable)Boolean.valueOf(false)), false)) {
                            if (OreDrillDefinition.allBlocksMatch(w, player, this.getAirBlocks(w, masterPos.func_177967_a(drill_direction, engines), drill_direction, rad, rods - 1), Blocks.field_150350_a.func_176223_P(), false)) {
                                return true;
                            }
                            OreDrillDefinition.sendErrorMSG(w, masterPos, player, 4);
                        } else {
                            OreDrillDefinition.sendErrorMSG(w, masterPos, player, 3);
                        }
                    } else {
                        OreDrillDefinition.sendErrorMSG(w, masterPos, player, 2);
                    }
                } else {
                    OreDrillDefinition.sendErrorMSG(w, masterPos, player, 1);
                }
            } else {
                OreDrillDefinition.sendErrorMSG(w, masterPos, player, 9);
            }
            return false;
        }
        if (engines < 0) {
            OreDrillDefinition.sendErrorPing(w, masterPos.func_177967_a(drill_direction, -engines + 1), player, 0, false);
        } else if (rods < 0) {
            OreDrillDefinition.sendErrorPing(w, masterPos.func_177967_a(drill_direction, -rods + Math.abs(engines) + 1), player, 0, false);
        }
        return false;
    }

    public boolean checkDrillSize(int rods, int engines, int radius) {
        return rods >= radius * 2 + 1 && rods >= engines && engines > radius;
    }

    public static EnumFacing getSide1(EnumFacing facing) {
        switch (facing.func_176740_k()) {
            case X: {
                return EnumFacing.DOWN;
            }
            case Y: {
                return EnumFacing.NORTH;
            }
            case Z: {
                return EnumFacing.DOWN;
            }
        }
        return EnumFacing.DOWN;
    }

    public static EnumFacing getSide2(EnumFacing facing) {
        switch (facing.func_176740_k()) {
            case X: {
                return EnumFacing.NORTH;
            }
            case Y: {
                return EnumFacing.EAST;
            }
            case Z: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.DOWN;
    }

    protected ArrayList<BlockPos> getEngineBlocks(World w, BlockPos masterPos, EnumFacing direction, int radius, int len) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>((radius * 2 + 1) * (radius * 2 + 1) * len);
        for (int r1 = -radius; r1 <= radius; ++r1) {
            for (int r2 = -radius; r2 <= radius; ++r2) {
                for (int h = 0; h < len; ++h) {
                    BlockPos p = masterPos.func_177967_a(direction, h + 1).func_177967_a(OreDrillDefinition.getSide1(direction), r1).func_177967_a(OreDrillDefinition.getSide2(direction), r2);
                    positions.add(p);
                }
            }
        }
        return positions;
    }

    protected ArrayList<BlockPos> getAirBlocks(World w, BlockPos startPos, EnumFacing direction, int radius, int len) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int r1 = -radius; r1 <= radius; ++r1) {
            for (int r2 = -radius; r2 <= radius; ++r2) {
                for (int h = 0; h < len; ++h) {
                    if (r1 == 0 && r2 == 0) continue;
                    BlockPos p = startPos.func_177967_a(direction, h + 1).func_177967_a(OreDrillDefinition.getSide1(direction), r1).func_177967_a(OreDrillDefinition.getSide2(direction), r2);
                    positions.add(p);
                }
            }
        }
        return positions;
    }

    protected ArrayList<BlockPos> getFrameBlocks(World w, BlockPos masterPos, EnumFacing direction, int radius, int len, boolean outer, boolean lastRow) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int r1 = -radius; r1 <= radius; ++r1) {
            for (int r2 = -radius; r2 <= radius; ++r2) {
                for (int h = 0; h < len; ++h) {
                    BlockPos p;
                    if (outer && this.isFramePos(r1, r2, h, radius, len)) {
                        p = masterPos.func_177967_a(direction, h + 1).func_177967_a(OreDrillDefinition.getSide1(direction), r1).func_177967_a(OreDrillDefinition.getSide2(direction), r2);
                        positions.add(p);
                        continue;
                    }
                    if (outer || !this.isScaffoldPos(r1, r2, h, radius, len) || lastRow && h == len - 1) continue;
                    p = masterPos.func_177967_a(direction, h + 1).func_177967_a(OreDrillDefinition.getSide1(direction), r1).func_177967_a(OreDrillDefinition.getSide2(direction), r2);
                    positions.add(p);
                }
            }
        }
        return positions;
    }

    protected ArrayList<BlockPos> getFinalScaffoldRow(World w, BlockPos masterPos, EnumFacing direction, int radius, int len) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>((radius * 2 + 1) * (radius * 2 + 1) - 1);
        for (int r1 = -radius; r1 <= radius; ++r1) {
            for (int r2 = -radius; r2 <= radius; ++r2) {
                if (r1 == 0 && r2 == 0) continue;
                BlockPos p = masterPos.func_177967_a(direction, len).func_177967_a(OreDrillDefinition.getSide1(direction), r1).func_177967_a(OreDrillDefinition.getSide2(direction), r2);
                positions.add(p);
            }
        }
        return positions;
    }

    protected boolean isFramePos(int r1, int r2, int h, int radius, int len) {
        int minc = 0;
        if (Math.abs(r1) == radius) {
            ++minc;
        }
        if (Math.abs(r2) == radius) {
            ++minc;
        }
        if (h == 0 || h == len - 1) {
            ++minc;
        }
        return minc >= 2;
    }

    protected boolean isScaffoldPos(int r1, int r2, int h, int radius, int len) {
        if (h == 0) {
            return false;
        }
        int minc = 0;
        if (Math.abs(r1) == radius) {
            ++minc;
        }
        if (Math.abs(r2) == radius) {
            ++minc;
        }
        if (h == len - 1) {
            return ++minc == 1 && (r1 != 0 || r2 != 0);
        }
        return minc == 1;
    }

    @Override
    public boolean form(World w, EntityPlayer player, BlockPos masterPos, EnumFacing direction) {
        TileEntity tile = w.func_175625_s(masterPos);
        if (tile != null && tile instanceof OreDrillTileEntMaster) {
            OreDrillTileEntMaster master = (OreDrillTileEntMaster)tile;
            int dir = this.getDirection(w, player, masterPos);
            if (dir < 0) {
                return false;
            }
            EnumFacing drill_direction = EnumFacing.func_82600_a((int)dir);
            int[] length = this.checkLength(w, masterPos, drill_direction);
            int engines = length[0];
            int rods = length[1];
            if (engines >= 0 && rods > 0) {
                if (engines == 0 && rods == 1) {
                    master.formOreDrill(direction, engines, rods, 0, drill_direction);
                    this.linkSlave(w, player, masterPos.func_177967_a(drill_direction, 1), 0, masterPos);
                    return true;
                }
                int rad = this.checkWidth(w, masterPos, drill_direction);
                master.formOreDrill(direction, engines, rods, rad, drill_direction);
                for (int i = engines; i < engines + rods + 1; ++i) {
                    this.linkSlave(w, player, masterPos.func_177967_a(drill_direction, i), 0, masterPos);
                }
                this.getEngineBlocks(w, masterPos, drill_direction, rad, engines).forEach(p -> this.linkSlave(w, player, (BlockPos)p, 1, masterPos));
                this.getFrameBlocks(w, masterPos, drill_direction, rad + 1, engines + rods, true, true).forEach(p -> this.linkSlave(w, player, (BlockPos)p, 2, masterPos));
                this.getFrameBlocks(w, masterPos, drill_direction, rad + 1, engines + rods, false, false).forEach(p -> this.linkSlave(w, player, (BlockPos)p, 3, masterPos));
                this.getFinalScaffoldRow(w, masterPos, drill_direction, rad, engines + rods).forEach(p -> this.linkSlave(w, player, (BlockPos)p, 4, masterPos));
            }
        }
        return false;
    }

    @Override
    protected void updateBlockStateForm(World w, BlockPos pos, int type) {
        if (type == 4) {
            w.func_180501_a(pos, w.func_180495_p(pos).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.SCAFFOLD_HIDDEN)), 3);
        } else {
            super.updateBlockStateForm(w, pos, type);
        }
    }

    @Override
    protected void updateBlockStateUnform(World w, BlockPos pos, IBlockState bs, int type) {
        if (bs.func_177229_b((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE) == EnumOreDrillType.SCAFFOLD_HIDDEN) {
            w.func_180501_a(pos, w.func_180495_p(pos).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.SCAFFOLD)), 3);
        } else {
            super.updateBlockStateUnform(w, pos, bs, type);
        }
    }

    @Override
    public void unform(World w, MultiBlockMachineTileEntMaster master) {
        if (master instanceof OreDrillTileEntMaster) {
            OreDrillTileEntMaster masterTile = (OreDrillTileEntMaster)master;
            EnumFacing drill_direction = masterTile.getDrill_direction();
            int engines = masterTile.getEngines();
            int rods = masterTile.getRods();
            BlockPos masterPos = masterTile.func_174877_v();
            if (engines == 0 && rods == 1) {
                this.unlinkSlave(w, masterPos.func_177967_a(drill_direction, 1));
                master.unform();
                return;
            }
            int rad = masterTile.getRadius();
            for (int i = engines; i < engines + rods + 1; ++i) {
                this.unlinkSlave(w, masterPos.func_177967_a(drill_direction, i));
            }
            this.getEngineBlocks(w, masterPos, drill_direction, rad, engines).forEach(p -> this.unlinkSlave(w, (BlockPos)p));
            this.getFrameBlocks(w, masterPos, drill_direction, rad + 1, engines + rods, true, true).forEach(p -> this.unlinkSlave(w, (BlockPos)p));
            this.getFrameBlocks(w, masterPos, drill_direction, rad + 1, engines + rods, false, false).forEach(p -> this.unlinkSlave(w, (BlockPos)p));
            this.getFinalScaffoldRow(w, masterPos, drill_direction, rad, engines + rods).forEach(p -> this.unlinkSlave(w, (BlockPos)p));
            master.unform();
        }
    }

    @Override
    public boolean canFormFromSide(EnumFacing side) {
        return true;
    }

    protected int getDirection(World w, EntityPlayer ply, BlockPos startPos) {
        int dir = -1;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!this.checkBlock(w, startPos.func_177972_a(f))) continue;
            if (dir == -1) {
                dir = f.ordinal();
                continue;
            }
            OreDrillDefinition.sendErrorPing(w, startPos.func_177967_a(f, 1), ply, 0, false);
            return -1;
        }
        return dir;
    }

    protected int checkWidth(World w, BlockPos p, EnumFacing dir) {
        BlockPos enginePos = p.func_177967_a(dir, 1);
        int rad = 0;
        for (EnumFacing facing : DIRECTIONS_AROUND_AXIS[dir.func_176740_k().ordinal()]) {
            int result = this.countEngines(w, enginePos, facing);
            if (result <= rad) continue;
            rad = result;
        }
        return rad;
    }

    protected int countEngines(World w, BlockPos p, EnumFacing dir) {
        int count;
        for (count = 0; this.isDrillType(w, p.func_177967_a(dir, count + 1), EnumOreDrillType.ENGINE) && count < 3; ++count) {
        }
        return count;
    }

    protected int[] checkLength(World w, BlockPos p, EnumFacing dir) {
        int engines = 0;
        int rods = 0;
        if (this.isDrillType(w, p.func_177967_a(dir, 1), EnumOreDrillType.ROD)) {
            ++rods;
            if (OreDrillDefinition.isOreCluster(w, p.func_177967_a(dir, 2))) {
                return new int[]{0, 1};
            }
            return new int[]{-1, -1};
        }
        if (this.isDrillType(w, p.func_177967_a(dir, 1), EnumOreDrillType.ENGINE)) {
            ++engines;
            while (this.isDrillType(w, p.func_177967_a(dir, engines + 1), EnumOreDrillType.ENGINE) && engines < 16) {
                ++engines;
            }
            if (this.isDrillType(w, p.func_177967_a(dir, engines + rods + 1), EnumOreDrillType.ROD)) {
                ++rods;
                while (this.isDrillType(w, p.func_177967_a(dir, engines + rods + 1), EnumOreDrillType.ROD) && rods < 16) {
                    ++rods;
                }
                if (OreDrillDefinition.isOreCluster(w, p.func_177967_a(dir, engines + rods + 1))) {
                    return new int[]{engines, rods};
                }
                return new int[]{engines, -rods};
            }
            return new int[]{-engines, -1};
        }
        return new int[]{-1, -1};
    }

    public static boolean isOreCluster(World w, BlockPos p) {
        IBlockState bs = w.func_180495_p(p);
        return bs.func_177230_c() instanceof BlockOreCluster;
    }

    protected boolean isDrillType(World w, BlockPos p, EnumOreDrillType type) {
        IBlockState bs = w.func_180495_p(p);
        if (bs.func_177230_c() == TGBlocks.ORE_DRILL_BLOCK) {
            EnumOreDrillType t = (EnumOreDrillType)((Object)bs.func_177229_b((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE));
            boolean formed = (Boolean)bs.func_177229_b((IProperty)BlockOreDrill.FORMED);
            if (!formed && t == type) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkBlock(World w, BlockPos p) {
        IBlockState bs = w.func_180495_p(p);
        if (bs.func_177230_c() == TGBlocks.ORE_DRILL_BLOCK) {
            EnumOreDrillType type = (EnumOreDrillType)((Object)bs.func_177229_b((IProperty)TGBlocks.ORE_DRILL_BLOCK.MACHINE_TYPE));
            boolean formed = (Boolean)bs.func_177229_b((IProperty)BlockOreDrill.FORMED);
            if (!(formed || type != EnumOreDrillType.ROD && type != EnumOreDrillType.ENGINE)) {
                return true;
            }
        }
        return false;
    }
}

