/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines.multiblocks;

import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.packets.PacketMultiBlockFormInvalidBlockMessage;
import techguns.packets.PacketSpawnParticle;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.MultiBlockMachineTileEntSlave;

public abstract class MultiBlockMachineSchematic {
    protected Class<? extends MultiBlockMachineTileEntMaster> mastertileClazz;

    public MultiBlockMachineSchematic(Class<? extends MultiBlockMachineTileEntMaster> mastertileClazz) {
        this.mastertileClazz = mastertileClazz;
    }

    public abstract boolean checkForm(World var1, EntityPlayer var2, BlockPos var3, EnumFacing var4);

    public abstract boolean form(World var1, EntityPlayer var2, BlockPos var3, EnumFacing var4);

    public abstract void unform(World var1, MultiBlockMachineTileEntMaster var2);

    public abstract boolean canFormFromSide(EnumFacing var1);

    protected static boolean allBlocksMatch(World w, EntityPlayer player, ArrayList<BlockPos> positions, IBlockState blockstate) {
        return MultiBlockMachineSchematic.allBlocksMatch(w, player, positions, blockstate, false);
    }

    protected static boolean allBlocksMatch(World w, EntityPlayer player, ArrayList<BlockPos> positions, IBlockState blockstate, boolean message) {
        boolean valid = true;
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos p = positions.get(i);
            if (w.func_180495_p(p) == blockstate) continue;
            MultiBlockMachineSchematic.sendErrorPing(w, p, player, 0, message);
            valid = false;
        }
        return valid;
    }

    protected static void sendErrorPing(World w, BlockPos p, EntityPlayer player, int type, boolean message) {
        if (!w.field_72995_K) {
            TGPackets.network.sendTo((IMessage)new PacketSpawnParticle("MultiblockInvalidPing", (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5), (EntityPlayerMP)player);
            if (message) {
                TGPackets.network.sendTo((IMessage)new PacketMultiBlockFormInvalidBlockMessage(p, type), (EntityPlayerMP)player);
            }
        }
    }

    protected static void sendErrorMSG(World w, BlockPos p, EntityPlayer player, int msgID) {
        if (!w.field_72995_K) {
            TGPackets.network.sendTo((IMessage)new PacketMultiBlockFormInvalidBlockMessage(p, msgID), (EntityPlayerMP)player);
        }
    }

    protected void linkSlave(World w, EntityPlayer p, BlockPos pos, int type, BlockPos masterPos) {
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof MultiBlockMachineTileEntSlave) {
            MultiBlockMachineTileEntSlave slave = (MultiBlockMachineTileEntSlave)tile;
            slave.form(masterPos, (byte)type);
            if (!w.field_72995_K) {
                this.updateBlockStateForm(w, pos, type);
                slave.needUpdate();
            }
        }
    }

    protected void updateBlockStateForm(World w, BlockPos pos, int type) {
        w.func_180501_a(pos, w.func_180495_p(pos).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(true)), 3);
    }

    protected void updateBlockStateUnform(World w, BlockPos pos, IBlockState bs, int type) {
        w.func_180501_a(pos, bs.func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false)), 3);
    }

    protected void unlinkSlave(World w, BlockPos pos) {
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof MultiBlockMachineTileEntSlave) {
            IBlockState bs;
            MultiBlockMachineTileEntSlave slave = (MultiBlockMachineTileEntSlave)tile;
            int type = slave.getSlaveType();
            slave.unform();
            if (!w.field_72995_K && (bs = w.func_180495_p(pos)).func_177230_c() == slave.getMachineBlockType()) {
                this.updateBlockStateUnform(w, pos, bs, type);
                slave.needUpdate();
            }
        }
    }
}

