/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGConfig;
import techguns.api.machines.IMachineType;
import techguns.blocks.GenericBlock;
import techguns.blocks.GenericItemBlockMeta;
import techguns.blocks.GenericItemBlockMetaMachineBlock;
import techguns.blocks.machines.EnumMachineType;
import techguns.blocks.machines.multiblocks.MultiBlockRegister;
import techguns.events.TechgunsGuiHandler;
import techguns.tileentities.BasicInventoryTileEnt;
import techguns.tileentities.BasicOwnedTileEnt;
import techguns.tileentities.BasicRedstoneTileEnt;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.MultiBlockMachineTileEntSlave;
import techguns.tileentities.TurretTileEnt;
import techguns.util.TextUtil;

public class BasicMachine<T extends Enum<T> & IMachineType>
extends GenericBlock {
    protected Class<T> clazz;
    protected BlockStateContainer blockStateOverride;
    public PropertyEnum<T> MACHINE_TYPE;
    protected GenericItemBlockMeta itemblock;

    public BasicMachine(String name, Class<T> clazz) {
        super(name, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(4.0f);
        this.clazz = clazz;
        this.MACHINE_TYPE = PropertyEnum.func_177709_a((String)"machinetype", clazz);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.MACHINE_TYPE}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public String getNameSuffix(int meta) {
        IBlockState state = this.func_176203_a(meta);
        Enum t = (Enum)((Object)state.func_177229_b(this.MACHINE_TYPE));
        return t.toString().toLowerCase();
    }

    public BlockStateContainer func_176194_O() {
        return this.blockStateOverride;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P().func_177226_a(this.MACHINE_TYPE, state.func_177229_b(this.MACHINE_TYPE)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (Enum t : (Enum[])this.clazz.getEnumConstants()) {
            if (((IMachineType)((Object)t)).debugOnly() && !TGConfig.debug || ((IMachineType)((Object)t)).hideInCreative()) continue;
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(this.MACHINE_TYPE, (Comparable)((Object)t)))));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof BasicInventoryTileEnt) {
            ((BasicInventoryTileEnt)tile).onBlockBreak();
        } else if (tile != null && tile instanceof MultiBlockMachineTileEntSlave) {
            ((MultiBlockMachineTileEntSlave)tile).onBlockBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof BasicRedstoneTileEnt) {
            ((BasicRedstoneTileEnt)tile).onNeighborBlockChange();
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof BasicInventoryTileEnt) {
            BasicInventoryTileEnt tileent = (BasicInventoryTileEnt)tile;
            if (tileent.isUseableByPlayer(player)) {
                MultiBlockMachineTileEntMaster master;
                if (tile instanceof MultiBlockMachineTileEntMaster && !(master = (MultiBlockMachineTileEntMaster)tile).isFormed() && !player.func_70093_af() && MultiBlockRegister.canFormFromSide(tileent, facing)) {
                    if (MultiBlockRegister.canForm(master, player, facing) && MultiBlockRegister.form(tileent, player, facing)) {
                        master.needUpdate();
                    }
                    return true;
                }
                ItemStack helditem = player.func_184586_b(hand);
                if (!helditem.func_190926_b() && helditem.func_77973_b().getToolClasses(helditem).contains("wrench")) {
                    if (player.func_70093_af() && tileent.canBeWrenchDismantled() && !world.field_72995_K) {
                        NBTTagCompound tileEntTags = new NBTTagCompound();
                        tileent.writeNBTforDismantling(tileEntTags);
                        ItemStack item = new ItemStack((Block)this, 1, this.func_180651_a(state));
                        NBTTagCompound itemnbt = item.func_77978_p();
                        if (itemnbt == null) {
                            itemnbt = new NBTTagCompound();
                            item.func_77982_d(itemnbt);
                        }
                        itemnbt.func_74782_a("TileEntityData", (NBTBase)tileEntTags);
                        tileent.emptyContent();
                        world.func_175698_g(pos);
                        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, item));
                    } else if (tileent.canBeWrenchRotated()) {
                        if (tileent.hasRotation()) {
                            tileent.rotateTile(facing);
                        } else {
                            this.rotateBlock(world, pos, EnumFacing.UP);
                        }
                    }
                } else if (!helditem.func_190926_b() && this.hasBucketInteraction(state) && helditem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                    IFluidHandlerItem fluidhandler = (IFluidHandlerItem)helditem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    boolean interacted = tileent.onFluidContainerInteract(player, hand, fluidhandler, helditem);
                    if (interacted) {
                        if (!world.field_72995_K) {
                            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        return true;
                    }
                    if (!world.field_72995_K) {
                        TechgunsGuiHandler.openGuiForPlayer(player, tile);
                    }
                } else if (!world.field_72995_K) {
                    TechgunsGuiHandler.openGuiForPlayer(player, tile);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.container.security.denied")), true);
            }
        } else if (tile != null && tile instanceof MultiBlockMachineTileEntSlave) {
            MultiBlockMachineTileEntSlave slave = (MultiBlockMachineTileEntSlave)tile;
            if (slave.hasMaster()) {
                TileEntity master;
                if (!world.field_72995_K && (master = world.func_175625_s(slave.getMasterPos())) != null && master instanceof MultiBlockMachineTileEntMaster) {
                    TechgunsGuiHandler.openGuiForPlayer(player, master);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean hasBucketInteraction(IBlockState state) {
        return state.func_177229_b(this.MACHINE_TYPE) == EnumMachineType.CHEM_LAB;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((IMachineType)((Object)((Enum)((Object)state.func_177229_b(this.MACHINE_TYPE))))).getTile();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public ItemBlock createItemBlock() {
        GenericItemBlockMetaMachineBlock itemblock = new GenericItemBlockMetaMachineBlock(this);
        this.itemblock = itemblock;
        return itemblock;
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> event) {
        super.registerBlock(event);
        for (Enum t : (Enum[])this.clazz.getEnumConstants()) {
            if (TileEntity.func_190559_a(((IMachineType)((Object)t)).getTileClass()) != null) continue;
            GameRegistry.registerTileEntity(((IMachineType)((Object)t)).getTileClass(), (ResourceLocation)new ResourceLocation("techguns", ((IStringSerializable)t).func_176610_l()));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((IMachineType)((Object)((Enum)((Object)state.func_177229_b(this.MACHINE_TYPE))))).getIndex();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.MACHINE_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[meta]));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        Enum t = (Enum)((Object)state.func_177229_b(this.MACHINE_TYPE));
        return ((IMachineType)((Object)t)).getRenderType();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        Enum t = (Enum)((Object)state.func_177229_b(this.MACHINE_TYPE));
        return ((IMachineType)((Object)t)).getBlockRenderLayer() == layer;
    }

    public void onBlockPlacedByExtended(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, EnumFacing sideHit) {
        TileEntity tile = world.func_175625_s(pos);
        if (placer instanceof EntityPlayer && tile instanceof BasicOwnedTileEnt) {
            ((BasicOwnedTileEnt)tile).setOwner((EntityPlayer)placer);
        }
        if (tile instanceof BasicInventoryTileEnt) {
            BasicInventoryTileEnt invtile = (BasicInventoryTileEnt)tile;
            if (invtile.hasRotation()) {
                int dir = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                invtile.rotation = (byte)(dir % 4);
            }
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("TileEntityData")) {
                invtile.readNBTfromStackTag(stack.func_77978_p().func_74775_l("TileEntityData"));
            }
        }
        if (tile instanceof TurretTileEnt) {
            TurretTileEnt turret = (TurretTileEnt)tile;
            if (sideHit == EnumFacing.DOWN) {
                turret.setFacing(EnumFacing.DOWN);
            } else {
                turret.setFacing(EnumFacing.UP);
            }
            if (!turret.turretDeath) {
                turret.spawnTurret(world, pos);
            }
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public GenericItemBlockMeta getItemblock() {
        return this.itemblock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        for (int i = 0; i < ((Enum[])this.clazz.getEnumConstants()).length; ++i) {
            IBlockState state = this.func_176223_P().func_177226_a(this.MACHINE_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[i]));
            if (((IMachineType)((Object)((Enum[])this.clazz.getEnumConstants())[i])).getRenderType() == EnumBlockRenderType.MODEL) {
                ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("techguns", ((Enum[])this.clazz.getEnumConstants())[i].name().toLowerCase()), "inventory"));
                continue;
            }
            ForgeHooksClient.registerTESRItemStack((Item)this.itemblock, (int)this.func_176201_c(state), ((IMachineType)((Object)((Enum)((Object)state.func_177229_b(this.MACHINE_TYPE))))).getTileClass());
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.itemblock.getRegistryName(), "inventory"));
        }
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        BasicInventoryTileEnt invtile;
        TileEntity tile;
        if ((axis == EnumFacing.DOWN || axis == EnumFacing.UP) && (tile = world.func_175625_s(pos)) != null && tile instanceof BasicInventoryTileEnt && (invtile = (BasicInventoryTileEnt)tile).hasRotation()) {
            invtile.rotateTile();
            return true;
        }
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return ((IMachineType)((Object)((Enum)((Object)state.func_177229_b(this.MACHINE_TYPE))))).getSoundType();
    }
}

