/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import techguns.blocks.EnumCamoNetType;
import techguns.blocks.EnumConnectionType;
import techguns.blocks.GenericBlockMetaEnumCamoChangeable;

public class BlockTGCamoNet
extends GenericBlockMetaEnumCamoChangeable<EnumCamoNetType> {
    public static PropertyEnum<EnumConnectionType> CONNECTION = PropertyEnum.func_177709_a((String)"connection", EnumConnectionType.class);
    protected static final AxisAlignedBB COLLIDE_CENTER = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
    protected static final AxisAlignedBB COLLIDE_SOUTH = new AxisAlignedBB(0.4375, 0.0, 0.5625, 0.5625, 1.0, 1.0);
    protected static final AxisAlignedBB COLLIDE_NORTH = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.4375);
    protected static final AxisAlignedBB COLLIDE_EAST = new AxisAlignedBB(0.5625, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    protected static final AxisAlignedBB COLLIDE_WEST = new AxisAlignedBB(0.0, 0.0, 0.4375, 0.4375, 1.0, 0.5625);

    public BlockTGCamoNet(String name) {
        super(name, Material.field_151580_n, MapColor.field_151651_C, SoundType.field_185854_g, EnumCamoNetType.class);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.TYPE}).add(new IProperty[]{CONNECTION}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean n = this.canConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean e = this.canConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean s = this.canConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean w = this.canConnectTo(worldIn, pos, EnumFacing.WEST);
        return state.func_177226_a(CONNECTION, (Comparable)((Object)EnumConnectionType.get(n, e, s, w)));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLIDE_CENTER;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
        boolean n = this.canConnectTo((IBlockAccess)worldIn, pos, EnumFacing.NORTH);
        boolean e = this.canConnectTo((IBlockAccess)worldIn, pos, EnumFacing.EAST);
        boolean s = this.canConnectTo((IBlockAccess)worldIn, pos, EnumFacing.SOUTH);
        boolean w = this.canConnectTo((IBlockAccess)worldIn, pos, EnumFacing.WEST);
        if (n) {
            BlockTGCamoNet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLIDE_NORTH);
        }
        if (e) {
            BlockTGCamoNet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLIDE_EAST);
        }
        if (s) {
            BlockTGCamoNet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLIDE_SOUTH);
        }
        if (w) {
            BlockTGCamoNet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLIDE_WEST);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        float f = 0.4375f;
        float f1 = 0.5625f;
        float f2 = 0.4375f;
        float f3 = 0.5625f;
        boolean north = this.canConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean east = this.canConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean south = this.canConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean west = this.canConnectTo(worldIn, pos, EnumFacing.WEST);
        if (!(north || east || south || west)) {
            return new AxisAlignedBB((double)f, 0.0, (double)f2, (double)f1, 1.0, (double)f3);
        }
        if ((!west || !east) && (west || east || north || south)) {
            if (west && !east) {
                f = 0.0f;
            } else if (!west && east) {
                f1 = 1.0f;
            }
        } else {
            f = 0.0f;
            f1 = 1.0f;
        }
        if ((!north || !south) && (west || east || north || south)) {
            if (north && !south) {
                f2 = 0.0f;
            } else if (!north && south) {
                f3 = 1.0f;
            }
        } else {
            f2 = 0.0f;
            f3 = 1.0f;
        }
        return new AxisAlignedBB((double)f, 0.0, (double)f2, (double)f1, 1.0, (double)f3);
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block instanceof BlockTGCamoNet;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.MIDDLE_POLE_THIN;
    }

    @Override
    public void registerItemBlockModels() {
        for (int i = 0; i < ((EnumCamoNetType[])this.clazz.getEnumConstants()).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_inventory", "type=" + ((EnumCamoNetType[])this.clazz.getEnumConstants())[i].func_176610_l()));
        }
    }
}

