/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.blocks.GenericBlock;
import techguns.blocks.GenericItemBlockMeta;
import techguns.tileentities.BioBlobTileEnt;
import techguns.util.BlockUtils;

public class BlockBioblob
extends GenericBlock {
    public static final int SIZE_2_W = 1;
    public static final int SIZE_2_H = 5;
    public static final int SIZE_1_W = 3;
    public static final int SIZE_1_H = 4;
    public static final int SIZE_0_W = 5;
    public static final int SIZE_0_H = 3;
    public static final float FSIZE = 0.0625f;
    public static final PropertyInteger SIZE = PropertyInteger.func_177719_a((String)"size", (int)0, (int)2);
    protected ItemBlock itemblock;

    public BlockBioblob(String name) {
        super(name, Material.field_151571_B);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING_ALL, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)));
    }

    protected AxisAlignedBB getBB(IBlockState state, IBlockAccess w, BlockPos pos) {
        int size = 2;
        TileEntity tile = w.func_175625_s(pos);
        if (tile != null && tile instanceof BioBlobTileEnt) {
            size = ((BioBlobTileEnt)tile).getBlobSize();
        }
        switch (size) {
            case 0: {
                return this.getBBForRota(5, 3, (EnumFacing)state.func_177229_b((IProperty)FACING_ALL));
            }
            case 1: {
                return this.getBBForRota(3, 4, (EnumFacing)state.func_177229_b((IProperty)FACING_ALL));
            }
        }
        return this.getBBForRota(1, 5, (EnumFacing)state.func_177229_b((IProperty)FACING_ALL));
    }

    public int func_149750_m(IBlockState state) {
        return 7;
    }

    protected AxisAlignedBB getBBForRota(int W, int H, EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB((double)(0.0625f * (float)W), 0.0, (double)(0.0625f * (float)W), (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)H), (double)(0.0625f * (float)(16 - W)));
            }
            case WEST: {
                return new AxisAlignedBB(0.0, (double)(0.0625f * (float)W), (double)(0.0625f * (float)W), (double)(0.0625f * (float)H), (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)(16 - W)));
            }
            case NORTH: {
                return new AxisAlignedBB((double)(0.0625f * (float)W), (double)(0.0625f * (float)W), 0.0, (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)H));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)(0.0625f * (float)W), (double)(0.0625f * (float)W), (double)(0.0625f * (float)(16 - H)), (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)(16 - W)), 1.0);
            }
            case UP: {
                return new AxisAlignedBB((double)(0.0625f * (float)W), (double)(0.0625f * (float)(16 - H)), (double)(0.0625f * (float)W), (double)(0.0625f * (float)(16 - W)), 1.0, (double)(0.0625f * (float)(16 - W)));
            }
            case EAST: {
                return new AxisAlignedBB((double)(0.0625f * (float)(16 - H)), (double)(0.0625f * (float)W), (double)(0.0625f * (float)W), 1.0, (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)(16 - W)));
            }
        }
        return new AxisAlignedBB((double)(0.0625f * (float)W), 0.0, (double)(0.0625f * (float)W), (double)(0.0625f * (float)(16 - W)), (double)(0.0625f * (float)H), (double)(0.0625f * (float)(16 - W)));
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBB(state, source, pos);
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.getBB(blockState, worldIn, pos);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> event) {
        super.registerBlock(event);
        GameRegistry.registerTileEntity(BioBlobTileEnt.class, (ResourceLocation)new ResourceLocation("techguns", "bioblob"));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_ALL, SIZE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING_ALL, (Comparable)EnumFacing.field_82609_l[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING_ALL)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        int size = 0;
        if (tile != null && tile instanceof BioBlobTileEnt) {
            size = ((BioBlobTileEnt)tile).getBlobSize();
        }
        return state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size));
    }

    @Override
    public ItemBlock createItemBlock() {
        GenericItemBlockMeta itemblock = new GenericItemBlockMeta(this);
        this.itemblock = itemblock;
        return itemblock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        IBlockState state = this.func_176223_P();
        ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), BlockUtils.getBlockStateVariantString(state)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BioBlobTileEnt();
    }
}

