/*
 * Decompiled with CFR 0.152.
 */
package techguns;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import techguns.TGConfig;
import techguns.Techguns;
import techguns.blocks.BlockFluidAcid;
import techguns.init.ITGInitializer;

public class TGFluids
implements ITGInitializer {
    public static Fluid WATER;
    public static Fluid LAVA;
    public static Fluid MILK;
    public static ArrayList<Fluid> oils;
    public static ArrayList<Fluid> worldspawn_oils;
    public static Fluid OIL_WORLDSPAWN;
    public static ArrayList<Fluid> fuels;
    public static Fluid LIQUID_REDSTONE;
    public static Fluid LIQUID_COAL;
    public static Fluid ACID;
    public static Fluid LIQUID_ENDER;
    public static Fluid BIOFUEL;
    public static boolean addedMilk;
    public static ArrayList<IFluidBlock> FLUIDBLOCKS;
    public static Block BLOCK_FLUID_ACID;
    public static Block BLOCK_FLUID_MILK;
    public static boolean addedAcid;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        WATER = FluidRegistry.WATER;
        LAVA = FluidRegistry.LAVA;
        addedAcid = FluidRegistry.registerFluid((Fluid)new Fluid("creeper_acid", new ResourceLocation("techguns", "blocks/acid_still"), new ResourceLocation("techguns", "blocks/acid_flow")).setGaseous(false).setLuminosity(0).setUnlocalizedName("creeperAcid").setDensity(100));
        ACID = FluidRegistry.getFluid((String)"creeper_acid");
        if (addedAcid) {
            BLOCK_FLUID_ACID = ((Block)new BlockFluidAcid(ACID, Material.field_151586_h).setRegistryName(new ResourceLocation("techguns", "block_creeper_acid"))).func_149663_c("techguns.block_creeper_acid").func_149647_a(Techguns.tabTechgun);
        }
        addedMilk = FluidRegistry.registerFluid((Fluid)new Fluid("milk", new ResourceLocation("techguns", "blocks/milk_still"), new ResourceLocation("techguns", "blocks/milk_flow")).setUnlocalizedName("milk"));
        MILK = FluidRegistry.getFluid((String)"milk");
        if (addedMilk) {
            BLOCK_FLUID_MILK = ((Block)new BlockFluidAcid(MILK, Material.field_151586_h).setRegistryName(new ResourceLocation("techguns", "block_milk"))).func_149663_c("techguns.block_milk").func_149647_a(Techguns.tabTechgun);
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemBlock ib;
        if (BLOCK_FLUID_ACID != null) {
            ib = new ItemBlock(BLOCK_FLUID_ACID);
            ib.setRegistryName(BLOCK_FLUID_ACID.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)ib);
        }
        if (BLOCK_FLUID_MILK != null) {
            ib = new ItemBlock(BLOCK_FLUID_MILK);
            ib.setRegistryName(BLOCK_FLUID_MILK.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)ib);
        }
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (BLOCK_FLUID_ACID != null) {
            event.getRegistry().register((IForgeRegistryEntry)BLOCK_FLUID_ACID);
            FluidRegistry.addBucketForFluid((Fluid)ACID);
        }
        if (BLOCK_FLUID_MILK != null) {
            event.getRegistry().register((IForgeRegistryEntry)BLOCK_FLUID_MILK);
            FluidRegistry.addBucketForFluid((Fluid)MILK);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        if (BLOCK_FLUID_ACID != null) {
            Techguns.proxy.registerFluidModelsForFluidBlock(BLOCK_FLUID_ACID);
        }
        if (BLOCK_FLUID_MILK != null) {
            Techguns.proxy.registerFluidModelsForFluidBlock(BLOCK_FLUID_MILK);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    public static void RecipeInit() {
        Fluid f;
        for (String fluidName : TGConfig.fluidListFuel) {
            f = FluidRegistry.getFluid((String)fluidName);
            if (f == null) continue;
            fuels.add(f);
        }
        for (String fluidName : TGConfig.fluidListOil) {
            f = FluidRegistry.getFluid((String)fluidName);
            if (f == null) continue;
            oils.add(f);
        }
        for (String fluidName : TGConfig.fluidListOilWorldspawn) {
            f = FluidRegistry.getFluid((String)fluidName);
            if (f == null) continue;
            worldspawn_oils.add(f);
            if (f.getBlock() == null || OIL_WORLDSPAWN != null) continue;
            OIL_WORLDSPAWN = f;
        }
        LIQUID_REDSTONE = FluidRegistry.getFluid((String)"redstone");
        if (LIQUID_REDSTONE == null) {
            LIQUID_REDSTONE = LAVA;
        }
        if ((LIQUID_COAL = FluidRegistry.getFluid((String)"coal")) == null) {
            LIQUID_COAL = WATER;
        }
        if ((LIQUID_ENDER = FluidRegistry.getFluid((String)"ender")) == null) {
            LIQUID_ENDER = LAVA;
        }
        if ((BIOFUEL = FluidRegistry.getFluid((String)"biofuel")) == null) {
            BIOFUEL = LAVA;
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        oils = new ArrayList();
        worldspawn_oils = new ArrayList();
        OIL_WORLDSPAWN = null;
        fuels = new ArrayList();
        addedMilk = false;
        FLUIDBLOCKS = new ArrayList();
        addedAcid = false;
    }
}

