/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import fi.dy.masa.tellme.datadump.EntityCountDump;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorLoadedChunks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntitiesLister
extends ChunkProcessorLoadedChunks {
    private Multimap<ChunkPos, TileHolder> perChunkTiles = MultimapBuilder.hashKeys().arrayListValues().build();
    private int totalCount;
    private int tickingCount;

    @Override
    public void processChunk(Chunk chunk) {
        Map map = chunk.func_177434_r();
        ChunkPos pos = chunk.func_76632_l();
        int count = chunk.func_177434_r().size();
        if (count == 0) {
            ++this.chunksWithZeroCount;
        } else {
            int tickingCount = 0;
            for (Map.Entry entry : map.entrySet()) {
                TileEntity te = (TileEntity)entry.getValue();
                this.perChunkTiles.put((Object)pos, (Object)new TileHolder((BlockPos)entry.getKey(), te.getClass()));
                if (!(te instanceof ITickable)) continue;
                ++tickingCount;
            }
            this.totalCount += count;
            this.tickingCount += tickingCount;
        }
    }

    @Override
    public EntityCountDump createDump(World world) {
        EntityCountDump dump = new EntityCountDump(5);
        dump.addTitle("Region", "Chunk", "Position", "Tile", "Ticking");
        dump.addHeader("Loaded TileEntities by chunk:");
        for (ChunkPos chunkPos : this.perChunkTiles.keySet()) {
            ArrayList tiles = new ArrayList(this.perChunkTiles.get((Object)chunkPos));
            Collections.sort(tiles);
            for (TileHolder holder : tiles) {
                dump.addData(String.format("r.%d.%d", chunkPos.field_77276_a >> 5, chunkPos.field_77275_b >> 5), String.format("[%5d, %5d]", chunkPos.field_77276_a, chunkPos.field_77275_b), String.format("x: %d, y: %d, z: %d", holder.pos.func_177958_n(), holder.pos.func_177956_o(), holder.pos.func_177952_p()), String.valueOf(holder.clazz.getName()), ITickable.class.isAssignableFrom(holder.clazz) ? "yes" : "no");
            }
        }
        dump.addFooter(String.format("In total there were %d loaded TileEntities", this.totalCount));
        dump.addFooter(String.format("in %d chunks, of which %d are ticking.", this.getLoadedChunkCount() - this.chunksWithZeroCount, this.tickingCount));
        return dump;
    }

    private static class TileHolder
    implements Comparable<TileHolder> {
        public final Class<? extends TileEntity> clazz;
        public final BlockPos pos;

        public TileHolder(BlockPos pos, Class<? extends TileEntity> clazz) {
            this.pos = pos;
            this.clazz = clazz;
        }

        @Override
        public int compareTo(TileHolder other) {
            String nameOther;
            String nameThis = this.clazz.getName();
            int result = nameThis.compareTo(nameOther = other.clazz.getName());
            if (result != 0) {
                return result;
            }
            return this.pos.compareTo((Vec3i)other.pos);
        }
    }
}

