/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.datadump.EntityCountDump;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorLoadedChunks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EntitiesPerChunkCounter
extends ChunkProcessorLoadedChunks {
    private Map<ChunkPos, Integer> perChunkCount = new HashMap<ChunkPos, Integer>();
    private int totalCount;

    @Override
    public void processChunk(Chunk chunk) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        int total = 0;
        for (int i = 0; i < entityLists.length; ++i) {
            total += entityLists[i].size();
        }
        if (total == 0) {
            ++this.chunksWithZeroCount;
        } else {
            this.perChunkCount.put(chunk.func_76632_l(), total);
            this.totalCount += total;
        }
    }

    @Override
    public EntityCountDump createDump(World world) {
        ArrayList<ChunkProcessorLoadedChunks.CountsPerChunkHolder> counts = new ArrayList<ChunkProcessorLoadedChunks.CountsPerChunkHolder>();
        for (ChunkPos pos : this.perChunkCount.keySet()) {
            counts.add(new ChunkProcessorLoadedChunks.CountsPerChunkHolder(pos, this.perChunkCount.get(pos)));
        }
        Collections.sort(counts);
        EntityCountDump dump = new EntityCountDump(3);
        dump.addTitle("Count", "Chunk", "Region");
        dump.addHeader("Loaded entities by chunk:");
        for (ChunkProcessorLoadedChunks.CountsPerChunkHolder holder : counts) {
            dump.addData(String.valueOf(holder.count), String.format("[%5d, %5d]", holder.pos.field_77276_a, holder.pos.field_77275_b), String.format("r.%d.%d", holder.pos.field_77276_a >> 5, holder.pos.field_77275_b >> 5));
        }
        dump.addFooter(String.format("In total there were %d loaded entities in %d chunks.", this.totalCount, this.getLoadedChunkCount() - this.chunksWithZeroCount));
        return dump;
    }
}

