/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.ChatUtils;
import fi.dy.masa.tellme.util.NBTFormatter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemInfo {
    public static boolean areItemStacksEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return stack1.func_190926_b() == stack2.func_190926_b();
        }
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static List<String> getFullItemInfo(@Nonnull ItemStack stack) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ItemData.getFor(stack).toString());
        if (!stack.func_77942_o()) {
            return lines;
        }
        lines.add("");
        lines.add(stack.func_77978_p().toString());
        lines.add("");
        NBTFormatter.getPrettyFormattedNBT(lines, stack.func_77978_p());
        return lines;
    }

    public static void printBasicItemInfoToChat(EntityPlayer player, @Nonnull ItemStack stack) {
        player.func_145747_a(ItemData.getFor(stack).toChatMessage());
    }

    public static void printItemInfoToConsole(@Nonnull ItemStack stack) {
        List<String> lines = ItemInfo.getFullItemInfo(stack);
        for (String line : lines) {
            TellMe.logger.info(line);
        }
    }

    public static void dumpItemInfoToFile(EntityPlayer player, @Nonnull ItemStack stack) {
        File file = DataDump.dumpDataToFile("item_data", ItemInfo.getFullItemInfo(stack));
        SubCommand.sendClickableLinkMessage((ICommandSender)player, "Output written to file %s", file);
    }

    public static void printItemInfo(EntityPlayer player, @Nonnull ItemStack stack, boolean dumpToFile) {
        ItemInfo.printBasicItemInfoToChat(player, stack);
        if (dumpToFile) {
            ItemInfo.dumpItemInfoToFile(player, stack);
        } else {
            ItemInfo.printItemInfoToConsole(stack);
        }
    }

    public static class ItemData {
        private final String regName;
        private final int id;
        private final int meta;
        private final String displayName;
        private final String nbtInfo;

        public ItemData(String displayName, String regName, int id, int meta, String nbtInfo) {
            this.displayName = displayName;
            this.regName = regName;
            this.id = id;
            this.meta = meta;
            this.nbtInfo = nbtInfo;
        }

        public static ItemData getFor(ItemStack stack) {
            String registryName = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString();
            String nbtInfo = stack.func_77942_o() ? "has NBT data" : "no NBT data";
            return new ItemData(stack.func_82833_r(), registryName, Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j(), nbtInfo);
        }

        public ITextComponent toChatMessage() {
            String copyStr = this.meta != 0 ? this.regName + ":" + this.meta : this.regName;
            String textPre = String.format("%s (", this.displayName);
            String textPost = String.format(" - %d:%d) %s", this.id, this.meta, this.nbtInfo);
            return ChatUtils.getClipboardCopiableMessage(textPre, copyStr, textPost);
        }

        public String toString() {
            return String.format("%s (%s - %d:%d) %s", this.displayName, this.regName, this.id, this.meta, this.nbtInfo);
        }
    }
}

