/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.ChatUtils;
import fi.dy.masa.tellme.util.NBTFormatter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityInfo {
    private static String getBasicEntityInfo(Entity target) {
        ResourceLocation rl = EntityList.func_191301_a((Entity)target);
        String regName = rl != null ? rl.toString() : "null";
        return String.format("Entity: %s [registry name: %s] (entityId: %d)", target.func_70005_c_(), regName, target.func_145782_y());
    }

    public static List<String> getFullEntityInfo(Entity target) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(EntityInfo.getBasicEntityInfo(target));
        NBTTagCompound nbt = new NBTTagCompound();
        if (!target.func_70039_c(nbt)) {
            target.func_189511_e(nbt);
        }
        lines.add("Entity class: " + target.getClass().getName());
        lines.add("");
        if (target instanceof EntityLivingBase) {
            lines.addAll(EntityInfo.getActivePotionEffectsForEntity((EntityLivingBase)target, DataDump.Format.ASCII));
            lines.add("");
        }
        NBTFormatter.getPrettyFormattedNBT(lines, nbt);
        return lines;
    }

    public static List<String> getActivePotionEffectsForEntity(EntityLivingBase entity, DataDump.Format format) {
        Collection effects = entity.func_70651_bq();
        if (!effects.isEmpty()) {
            DataDump dump = new DataDump(4, format);
            for (PotionEffect effect : effects) {
                ResourceLocation rl = effect.func_188419_a().getRegistryName();
                dump.addData(rl != null ? rl.toString() : effect.getClass().getName(), String.valueOf(effect.func_76458_c()), String.valueOf(effect.func_76459_b()), String.valueOf(effect.func_82720_e()));
            }
            dump.addTitle("Effect", "Amplifier", "Duration", "Ambient");
            dump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
            dump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
            dump.setUseColumnSeparator(true);
            return dump.getLines();
        }
        return Collections.emptyList();
    }

    public static void printBasicEntityInfoToChat(EntityPlayer player, Entity target) {
        ResourceLocation rl = EntityList.func_191301_a((Entity)target);
        String regName = rl != null ? rl.toString() : "null";
        String textPre = String.format("Entity: %s [registry name: ", target.func_70005_c_());
        String textPost = String.format("] (entityId: %d)", target.func_145782_y());
        player.func_145747_a(ChatUtils.getClipboardCopiableMessage(textPre, regName, textPost));
    }

    public static void printFullEntityInfoToConsole(EntityPlayer player, Entity target) {
        List<String> lines = EntityInfo.getFullEntityInfo(target);
        for (String line : lines) {
            TellMe.logger.info(line);
        }
    }

    public static void printEntityInfo(EntityPlayer player, Entity target, boolean dumpToFile) {
        EntityInfo.printBasicEntityInfoToChat(player, target);
        if (dumpToFile) {
            EntityInfo.dumpFullEntityInfoToFile(player, target);
        } else {
            EntityInfo.printFullEntityInfoToConsole(player, target);
        }
    }

    public static void dumpFullEntityInfoToFile(EntityPlayer player, Entity target) {
        File file = DataDump.dumpDataToFile("entity_data", EntityInfo.getFullEntityInfo(target));
        SubCommand.sendClickableLinkMessage((ICommandSender)player, "Output written to file %s", file);
    }

    public static List<String> getPlayerList(DataDump.Format format) {
        DataDump dump = new DataDump(6, format);
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            String name = player.func_70005_c_();
            String dim = String.valueOf(player.func_130014_f_().field_73011_w.getDimension());
            String health = String.format("%.2f", Float.valueOf(player.func_110143_aJ()));
            BlockPos pos = new BlockPos((Entity)player);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            String blockPos = String.format("x: %d, y: %d, z: %d", x, y, z);
            String chunkPos = String.format("cx: %d, cy: %d, cz: %d", x >> 4, y >> 4, z >> 4);
            String regionPos = String.format("r.%d.%d", x >> 9, z >> 9);
            dump.addData(name, health, dim, blockPos, chunkPos, regionPos);
        }
        dump.addTitle("Name", "Health", "Dimension", "Position", "Chunk", "Region");
        dump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
        dump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        dump.setColumnProperties(3, DataDump.Alignment.RIGHT, false);
        dump.setColumnProperties(4, DataDump.Alignment.RIGHT, false);
        dump.setColumnProperties(5, DataDump.Alignment.RIGHT, false);
        dump.setUseColumnSeparator(true);
        return dump.getLines();
    }

    public static String getEntityNameFromClass(Class<? extends Entity> clazz) {
        EntityEntry entry;
        String name = null;
        ResourceLocation rl = EntityList.func_191306_a(clazz);
        if (rl != null && (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(rl)) != null) {
            name = entry.getName();
        }
        if (name == null) {
            name = clazz.getSimpleName();
        }
        return name;
    }
}

